/*
 * Decompiled with CFR 0.152.
 */
package net.jrouter.http.servlet.result;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jrouter.annotation.ResultType;
import net.jrouter.http.servlet.ServletActionInvocation;

public class ServletResult {
    public static final String ACTION_FORWARD = "action_forward";
    public static final String FORWARD = "forward";
    public static final String REDIRECT = "redirect";

    @ResultType(type="action_forward")
    public static Object actionForward(ServletActionInvocation invocation) {
        return invocation.getActionFactory().invokeAction((Object)invocation.getResult().location(), invocation.getParameters());
    }

    @ResultType(type="forward")
    public static void forward(ServletActionInvocation invocation) throws IOException, ServletException {
        HttpServletRequest request;
        HttpServletResponse response = invocation.getResponse();
        if (response.isCommitted()) {
            return;
        }
        String location = invocation.getResult().location();
        if (location.charAt(0) != '/') {
            location = '/' + location;
        }
        if ((request = invocation.getRequest()).getContextPath() != null && request.getContextPath().length() > 0) {
            location = request.getContextPath() + location;
        }
        request.getRequestDispatcher(location).forward((ServletRequest)request, (ServletResponse)response);
    }

    @ResultType(type="redirect")
    public static void redirect(ServletActionInvocation invocation) throws IOException {
        HttpServletRequest request;
        HttpServletResponse response = invocation.getResponse();
        if (response.isCommitted()) {
            return;
        }
        String location = invocation.getResult().location();
        if (location.charAt(0) != '/') {
            location = '/' + location;
        }
        if ((request = invocation.getRequest()).getContextPath() != null && request.getContextPath().length() > 0) {
            location = request.getContextPath() + location;
        }
        response.sendRedirect(location);
    }
}

