/*
 * Decompiled with CFR 0.152.
 */
package jrouter.servlet.spring;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jrouter.ObjectFactory;
import jrouter.impl.ResultTypeProxy;
import jrouter.servlet.ObjectHandlerActionFactory;
import jrouter.servlet.ServletActionFactory;
import jrouter.spring.SpringObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ObjectHandlerActionFactoryBean
implements FactoryBean<ObjectHandlerActionFactory>,
InitializingBean,
DisposableBean,
ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectHandlerActionFactoryBean.class);
    private ApplicationContext applicationContext;
    private Map<Class, String> objectResultTypes = Collections.EMPTY_MAP;
    private ServletActionFactory.DefaultServletActionFactory.Properties properties = null;
    private ObjectHandlerActionFactory actionFactory;

    public void afterPropertiesSet() throws Exception {
        if (this.properties == null) {
            this.properties = new ServletActionFactory.DefaultServletActionFactory.Properties();
            this.properties.setObjectFactory((ObjectFactory)new SpringObjectFactory(this.applicationContext));
        }
        this.actionFactory = new ObjectHandlerActionFactory(this.properties);
        HashMap<Class, ResultTypeProxy> tmpObjectResultTypes = new HashMap<Class, ResultTypeProxy>(2);
        if (this.objectResultTypes != null && !this.objectResultTypes.isEmpty()) {
            for (Map.Entry<Class, String> e : this.objectResultTypes.entrySet()) {
                Class classType = e.getKey();
                String resultType = e.getValue();
                ResultTypeProxy type = (ResultTypeProxy)this.actionFactory.getResultTypes().get(resultType);
                if (type == null) {
                    LOG.info("Can't find ResultType [{}] for [{}], use default [{}]", new Object[]{resultType, classType, this.actionFactory.getDefaultResultType()});
                    continue;
                }
                if (String.class == classType) {
                    LOG.warn("Set [java.lang.String] type is usually invalid when using PathActionFactory or it's subtypes");
                }
                LOG.info("Set ResultType [{}] for class [{}]", (Object)resultType, (Object)classType.getName());
                tmpObjectResultTypes.put(classType, type);
            }
        }
        this.actionFactory.setObjectResultTypes(Collections.unmodifiableMap(tmpObjectResultTypes));
    }

    public ObjectHandlerActionFactory getObject() throws Exception {
        return this.actionFactory;
    }

    public Class<?> getObjectType() {
        return this.actionFactory.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.actionFactory != null) {
            this.actionFactory.clear();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setObjectResultTypes(Map<Class, String> objectResultTypes) {
        this.objectResultTypes = objectResultTypes;
    }

    public void setProperties(ServletActionFactory.DefaultServletActionFactory.Properties properties) {
        this.properties = properties;
    }
}

