/*
 * Decompiled with CFR 0.152.
 */
package jrouter.servlet.filter;

import java.util.HashMap;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import jrouter.ActionFactory;
import jrouter.config.Configuration;
import jrouter.servlet.filter.JRouterFilter;
import jrouter.spring.SpringObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringJRouterFilter
extends JRouterFilter {
    private static final Logger log = LoggerFactory.getLogger(SpringJRouterFilter.class);
    private boolean useSpringObjectFactory = true;

    @Override
    public void init(FilterConfig filterConfig) {
        String useSpring = filterConfig.getInitParameter("useSpringObjectFactory");
        if (useSpring != null) {
            this.useSpringObjectFactory = Boolean.parseBoolean(useSpring);
        }
        super.init(filterConfig);
    }

    @Override
    protected ActionFactory createActionFactory(FilterConfig filterConfig) {
        log.info("Load configuration location : {}", (Object)this.getConfigLocation());
        Configuration configuration = new Configuration();
        configuration.load(this.getConfigLocation());
        if (this.useSpringObjectFactory) {
            HashMap<String, SpringObjectFactory> actionFactoryProperties = new HashMap<String, SpringObjectFactory>(2);
            actionFactoryProperties.put("objectFactory", new SpringObjectFactory((ApplicationContext)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)filterConfig.getServletContext())));
            configuration.addActionFactoryProperties(actionFactoryProperties);
        }
        return configuration.buildActionFactory();
    }

    public boolean isUseSpringObjectFactory() {
        return this.useSpringObjectFactory;
    }

    public void setUseSpringObjectFactory(boolean useSpringObjectFactory) {
        this.useSpringObjectFactory = useSpringObjectFactory;
    }
}

