/*
 * Decompiled with CFR 0.152.
 */
package jrouter.servlet.filter;

import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import jrouter.ActionFactory;
import jrouter.servlet.filter.AbstractJRouterFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringBeanJRouterFilter
extends AbstractJRouterFilter {
    private static final Logger log = LoggerFactory.getLogger(SpringBeanJRouterFilter.class);
    private String beanName;

    @Override
    public void init(FilterConfig filterConfig) {
        String varBeanName = filterConfig.getInitParameter("beanName");
        if (varBeanName != null) {
            this.beanName = varBeanName;
            log.info("Set bean's name of springframework : {}", (Object)this.beanName);
        }
        super.init(filterConfig);
    }

    @Override
    protected ActionFactory createActionFactory(FilterConfig filterConfig) {
        return this.beanName == null ? (ActionFactory)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)filterConfig.getServletContext()).getBean(ActionFactory.class) : (ActionFactory)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)filterConfig.getServletContext()).getBean(this.beanName, ActionFactory.class);
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }
}

