/*
 * Decompiled with CFR 0.152.
 */
package jrouter.servlet.filter;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import jrouter.ActionFactory;
import jrouter.NotFoundException;
import jrouter.impl.InvocationProxyException;
import jrouter.servlet.ServletActionFactory;
import jrouter.servlet.ServletThreadContext;
import jrouter.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJRouterFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AbstractJRouterFilter.class);
    private String encoding = null;
    private boolean trimRequestParameter = false;
    private boolean useThreadLocal = true;
    private ActionFactory actionFactory;
    private boolean isServletActionFactory = false;
    private String factoryName = null;
    private boolean logNotFoundException = true;
    protected ServletContext servletContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig filterConfig) {
        String varEncoding = filterConfig.getInitParameter("encoding");
        String varTrimRequestParameter = filterConfig.getInitParameter("trimRequestParameter");
        String varFactoryName = filterConfig.getInitParameter("factoryName");
        String varUseThreadLocal = filterConfig.getInitParameter("useThreadLocal");
        String varLogNotFoundException = filterConfig.getInitParameter("logNotFoundException");
        if (varEncoding != null) {
            this.encoding = varEncoding;
            log.info("Set character encoding : {}", (Object)this.encoding);
        }
        if (varUseThreadLocal != null) {
            this.useThreadLocal = Boolean.parseBoolean(varUseThreadLocal);
        }
        if (varTrimRequestParameter != null) {
            this.trimRequestParameter = Boolean.parseBoolean(varTrimRequestParameter);
        }
        if (varLogNotFoundException != null) {
            this.logNotFoundException = Boolean.parseBoolean(varLogNotFoundException);
        }
        this.servletContext = filterConfig.getServletContext();
        try {
            if (this.useThreadLocal) {
                ServletThreadContext.setServletContext(this.servletContext);
            }
            this.actionFactory = this.createActionFactory(filterConfig);
            if (StringUtil.isNotBlank((CharSequence)varFactoryName)) {
                this.factoryName = varFactoryName;
                this.servletContext.setAttribute(this.factoryName, (Object)this.actionFactory);
                log.info("Set ActionFactory's name in ServletContext : {}", (Object)this.factoryName);
            }
            this.isServletActionFactory = this.actionFactory instanceof ServletActionFactory;
        }
        finally {
            if (this.useThreadLocal) {
                ServletThreadContext.remove();
            }
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        Map map;
        Object request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.encoding != null) {
            request.setCharacterEncoding(this.encoding);
            response.setCharacterEncoding(this.encoding);
        }
        if (this.trimRequestParameter && (map = request.getParameterMap()) != null && !map.isEmpty()) {
            request = new TrimParameterRequestWraper((HttpServletRequest)request);
        }
        if (this.useThreadLocal) {
            this.createServletThreadContext((HttpServletRequest)request, response);
        }
        try {
            if (this.isServletActionFactory) {
                ((ServletActionFactory)this.actionFactory).invokeAction(this.getActionPath((HttpServletRequest)request), (HttpServletRequest)request, response, this.servletContext);
            } else {
                this.actionFactory.invokeAction((Object)this.getActionPath((HttpServletRequest)request), new Object[0]);
            }
            if (!response.isCommitted()) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (NotFoundException e) {
            if (this.logNotFoundException) {
                log.error(e.getMessage(), (Throwable)e);
            }
            response.sendError(404, e.getMessage());
        }
        catch (InvocationProxyException e) {
            throw new ServletException(e.getSource());
        }
        finally {
            if (this.useThreadLocal) {
                ServletThreadContext.remove();
            }
        }
    }

    abstract ActionFactory createActionFactory(FilterConfig var1);

    public void destroy() {
        if (this.actionFactory != null) {
            this.actionFactory.clear();
        }
        ServletThreadContext.remove();
    }

    protected String getActionPath(HttpServletRequest request) {
        return request.getServletPath();
    }

    protected void createServletThreadContext(HttpServletRequest request, HttpServletResponse response) {
        ServletThreadContext.setRequest(request);
        ServletThreadContext.setResponse(response);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isTrimRequestParameter() {
        return this.trimRequestParameter;
    }

    public void setTrimRequestParameter(boolean trimRequestParameter) {
        this.trimRequestParameter = trimRequestParameter;
    }

    public boolean isUseThreadLocal() {
        return this.useThreadLocal;
    }

    public void setUseThreadLocal(boolean useThreadLocal) {
        this.useThreadLocal = useThreadLocal;
    }

    public ActionFactory getActionFactory() {
        return this.actionFactory;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }

    public boolean isLogNotFoundException() {
        return this.logNotFoundException;
    }

    public void setLogNotFoundException(boolean logNotFoundException) {
        this.logNotFoundException = logNotFoundException;
    }

    private static final class TrimParameterRequestWraper
    extends HttpServletRequestWrapper {
        public TrimParameterRequestWraper(HttpServletRequest request) {
            super(request);
        }

        public String getParameter(String name) {
            String val = super.getParameter(name);
            if (val != null) {
                val = val.trim();
            }
            return val;
        }
    }
}

