/*
 * Decompiled with CFR 0.152.
 */
package jrouter.servlet.spring;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jrouter.ActionFactory;
import jrouter.config.Configuration;
import jrouter.impl.ResultTypeProxy;
import jrouter.servlet.ObjectHandlerActionFactory;
import jrouter.spring.DefaultActionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectHandlerActionFactoryBean
extends DefaultActionFactoryBean<ObjectHandlerActionFactory> {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectHandlerActionFactoryBean.class);
    private Map<Class, String> objectResultTypes;

    protected void setDefaultActionFactoryClass(Configuration config) {
        config.setActionFactoryClass(ObjectHandlerActionFactory.class);
    }

    protected void afterActionFactoryCreation(ObjectHandlerActionFactory actionFactory) {
        super.afterActionFactoryCreation((ActionFactory)actionFactory);
        HashMap<Class, ResultTypeProxy> _objectResultTypes = new HashMap<Class, ResultTypeProxy>(2);
        if (this.objectResultTypes != null && !this.objectResultTypes.isEmpty()) {
            for (Map.Entry<Class, String> e : this.objectResultTypes.entrySet()) {
                Class classType = e.getKey();
                String resultType = e.getValue();
                ResultTypeProxy type = (ResultTypeProxy)actionFactory.getResultTypes().get(resultType);
                if (type == null) {
                    LOG.info("Can't find ResultType [{}] for [{}], use default [{}]", new Object[]{resultType, classType, actionFactory.getDefaultResultType()});
                    continue;
                }
                if (String.class == classType) {
                    LOG.warn("Set [java.lang.String] type is usually invalid when using PathActionFactory or it's subtypes");
                }
                LOG.info("Set ResultType [{}] for class [{}]", (Object)resultType, (Object)classType.getName());
                _objectResultTypes.put(classType, type);
            }
        }
        actionFactory.setObjectResultTypes(Collections.unmodifiableMap(_objectResultTypes));
    }

    public void setObjectResultTypes(Map<Class, String> objectResultTypes) {
        this.objectResultTypes = objectResultTypes;
    }
}

