/*
 * Decompiled with CFR 0.152.
 */
package jrouter.servlet;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jrouter.ActionInvocation;
import jrouter.servlet.RequestMap;

public class ServletThreadContext {
    private static final ThreadLocal<ServletThreadContext> THREAD_LOCAL = new ThreadLocal<ServletThreadContext>(){

        @Override
        protected ServletThreadContext initialValue() {
            return new ServletThreadContext(new HashMap(8));
        }
    };
    private ActionInvocation<?> actionInvocation;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private RequestMap requestMap;
    private ServletContext servletContext;
    private final Map<String, ?> contextMap;
    private Exception exception;

    private ServletThreadContext(Map<String, Object> contextMap) {
        this.contextMap = contextMap;
    }

    private static ServletThreadContext get() {
        return THREAD_LOCAL.get();
    }

    public static void remove() {
        Map<String, Object> map = null;
        map = ServletThreadContext.getRequestParameters();
        if (map != null) {
            map.clear();
        }
        if ((map = ServletThreadContext.getContextMap()) != null) {
            map.clear();
        }
        THREAD_LOCAL.remove();
    }

    public static <T extends ActionInvocation> T getActionInvocation() {
        return (T)ServletThreadContext.get().actionInvocation;
    }

    public static void setActionInvocation(ActionInvocation<?> actionInvocation) {
        ServletThreadContext.get().actionInvocation = actionInvocation;
    }

    public static void setRequest(HttpServletRequest request) {
        ServletThreadContext.get().request = request;
        ServletThreadContext.get().requestMap = new RequestMap(request);
    }

    public static HttpServletRequest getRequest() {
        return ServletThreadContext.get().request;
    }

    public static HttpSession getSession() {
        return ServletThreadContext.getRequest().getSession();
    }

    public static HttpSession getSession(boolean create) {
        return ServletThreadContext.getRequest().getSession(create);
    }

    public static Map<String, String[]> getRequestParameters() {
        return ServletThreadContext.get().requestMap;
    }

    public static void setResponse(HttpServletResponse response) {
        ServletThreadContext.get().response = response;
    }

    public static HttpServletResponse getResponse() {
        return ServletThreadContext.get().response;
    }

    public static ServletContext getServletContext() {
        return ServletThreadContext.get().servletContext;
    }

    public static void setServletContext(ServletContext servletContext) {
        ServletThreadContext.get().servletContext = servletContext;
    }

    public static <T> Map<String, T> getContextMap() {
        return ServletThreadContext.get().contextMap;
    }

    public static Exception getException() {
        return ServletThreadContext.get().exception;
    }

    public static void setException(Exception exception) {
        ServletThreadContext.get().exception = exception;
    }
}

