/*
 * Decompiled with CFR 0.152.
 */
package jrouter.servlet.filter;

import java.util.HashMap;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import jrouter.ActionFactory;
import jrouter.config.Configuration;
import jrouter.servlet.filter.JRouterFilter;
import jrouter.spring.SpringObjectFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringJRouterFilter
extends JRouterFilter {
    private boolean useSpringObjectFactory = true;

    @Override
    public void init(FilterConfig filterConfig) {
        String useSpring = filterConfig.getInitParameter("useSpringObjectFactory");
        if (useSpring != null) {
            this.useSpringObjectFactory = Boolean.parseBoolean(useSpring);
        }
        super.init(filterConfig);
    }

    @Override
    protected ActionFactory createActionFactory(FilterConfig filterConfig) {
        this.log.info("Load configuration location : {}", (Object)this.configLocation);
        Configuration configuration = new Configuration();
        configuration.load(this.configLocation);
        if (this.useSpringObjectFactory) {
            HashMap<String, SpringObjectFactory> actionFactoryProperties = new HashMap<String, SpringObjectFactory>(2);
            actionFactoryProperties.put("objectFactory", new SpringObjectFactory((ApplicationContext)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)filterConfig.getServletContext())));
            configuration.addActionFactoryProperties(actionFactoryProperties);
        }
        return configuration.buildActionFactory();
    }
}

