/*
 * Decompiled with CFR 0.152.
 */
package jrouter.servlet;

import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jrouter.ActionFactory;
import jrouter.ActionInvocation;
import jrouter.ActionProxy;
import jrouter.JRouterException;
import jrouter.ParameterConverter;
import jrouter.annotation.Result;
import jrouter.impl.PathActionFactory;
import jrouter.servlet.RequestMap;
import jrouter.servlet.ServletActionInvocation;
import jrouter.servlet.ServletThreadContext;

public interface ServletActionFactory
extends ActionFactory<String> {
    public <T> T invokeAction(String var1, HttpServletRequest var2, HttpServletResponse var3, ServletContext var4) throws JRouterException;

    public static class DefaultServletActionInvocation
    implements ServletActionInvocation {
        private final ActionInvocation<String> invocation;
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final RequestMap requestMap;
        private final ServletContext servletContext;
        private final Map<String, Object> contextMap;

        public DefaultServletActionInvocation(ActionInvocation<String> invocation, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Map<String, Object> contextMap) {
            this.invocation = invocation;
            this.request = request;
            this.requestMap = new RequestMap(request);
            this.response = response;
            this.servletContext = servletContext;
            this.contextMap = contextMap;
        }

        public ActionFactory getActionFactory() {
            return this.invocation.getActionFactory();
        }

        public ActionProxy getActionProxy() {
            return this.invocation.getActionProxy();
        }

        public boolean isExecuted() {
            return this.invocation.isExecuted();
        }

        public Object[] getParameters() {
            return this.invocation.getParameters();
        }

        public Object invoke(Object ... params) throws JRouterException {
            return this.invocation.invoke(params);
        }

        public Object invokeActionOnly(Object ... params) throws JRouterException {
            return this.invocation.invokeActionOnly(params);
        }

        public String getActionPath() {
            return (String)this.invocation.getActionPath();
        }

        public Object getInvokeResult() {
            return this.invocation.getInvokeResult();
        }

        public void setInvokeResult(Object result) {
            this.invocation.setInvokeResult(result);
        }

        public void setResult(Result result) {
            this.invocation.setResult(result);
        }

        public Result getResult() {
            return this.invocation.getResult();
        }

        public void setParameterConverter(ParameterConverter parameterConverter) {
            this.invocation.setParameterConverter(parameterConverter);
        }

        public ParameterConverter getParameterConverter() {
            return this.invocation.getParameterConverter();
        }

        public void setConvertParameters(Object ... params) {
            this.invocation.setConvertParameters(params);
        }

        public Object[] getConvertParameters() {
            return this.invocation.getConvertParameters();
        }

        @Override
        public HttpServletRequest getRequest() {
            return this.request;
        }

        @Override
        public HttpSession getSession() {
            return this.getRequest().getSession();
        }

        @Override
        public Map<String, String[]> getRequestParameters() {
            return this.requestMap;
        }

        @Override
        public HttpServletResponse getResponse() {
            return this.response;
        }

        @Override
        public ServletContext getServletContext() {
            return this.servletContext;
        }

        @Override
        public Map<String, Object> getContextMap() {
            return this.contextMap;
        }
    }

    public static class DefaultServletActionFactory
    extends PathActionFactory
    implements ServletActionFactory {
        private final boolean useThreadLocal = true;
        private boolean actionPathCaseSensitive = true;

        public DefaultServletActionFactory(Map<String, Object> properties) {
            super(properties);
            Object val = properties.get("actionPathCaseSensitive");
            if (val != null) {
                this.actionPathCaseSensitive = Boolean.valueOf(val.toString());
            }
        }

        @Override
        public <T> T invokeAction(String path, HttpServletRequest request, HttpServletResponse response, ServletContext sc) throws JRouterException {
            return (T)super.invokeAction(this.actionPathCaseSensitive ? path : path.toLowerCase(), new Object[]{request, response, sc});
        }

        protected ActionInvocation<String> createActionInvocation(String path, Object ... params) {
            ActionInvocation invocation = super.createActionInvocation(path, new Object[0]);
            DefaultServletActionInvocation servletInvocation = null;
            if (this.checkHttpParameters(params)) {
                servletInvocation = new DefaultServletActionInvocation((ActionInvocation<String>)invocation, (HttpServletRequest)params[0], (HttpServletResponse)params[1], (ServletContext)params[2], ServletThreadContext.<Object>getContextMap());
            }
            if (servletInvocation == null) {
                servletInvocation = new DefaultServletActionInvocation((ActionInvocation<String>)invocation, ServletThreadContext.getRequest(), ServletThreadContext.getResponse(), ServletThreadContext.getServletContext(), ServletThreadContext.<Object>getContextMap());
            }
            ServletThreadContext.setActionInvocation(servletInvocation);
            if (servletInvocation != null) {
                invocation.setParameterConverter(invocation.getActionFactory().getConverterFactory().getParameterConverter((ActionInvocation)servletInvocation));
                invocation.setConvertParameters(new Object[]{servletInvocation.getRequest(), servletInvocation.getResponse(), servletInvocation.getServletContext(), servletInvocation});
                return servletInvocation;
            }
            return invocation;
        }

        protected String buildActionPath(String namespace, String aname, Method method) {
            String path = super.buildActionPath(namespace, aname, method);
            return this.actionPathCaseSensitive ? path : path.toLowerCase();
        }

        private boolean checkHttpParameters(Object ... params) {
            return params != null && params.length == 3 && params[0] instanceof HttpServletRequest && params[1] instanceof HttpServletResponse && params[2] instanceof ServletContext;
        }

        public boolean isActionPathCaseSensitive() {
            return this.actionPathCaseSensitive;
        }
    }
}

