/*
 * Decompiled with CFR 0.152.
 */
package jrouter.servlet;

import java.util.Map;
import jrouter.AbstractProxy;
import jrouter.ActionInvocation;
import jrouter.impl.ResultTypeProxy;
import jrouter.servlet.ServletActionFactory;
import jrouter.util.MethodUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectHandlerActionFactory
extends ServletActionFactory.DefaultServletActionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectHandlerActionFactory.class);
    private ResultTypeProxy defaultObjectHandler;
    private Map<Class, ResultTypeProxy> objectResultTypes;

    public ObjectHandlerActionFactory(Map<String, Object> properties) {
        super(properties);
    }

    protected Object invokeObjectResult(ActionInvocation invocation, Object res) {
        ResultTypeProxy resultType = null;
        if (res != null && (resultType = this.objectResultTypes.get(res.getClass())) != null) {
            return MethodUtil.invoke((AbstractProxy)resultType, (ActionInvocation)invocation);
        }
        return MethodUtil.invoke((AbstractProxy)this.defaultObjectHandler, (ActionInvocation)invocation);
    }

    protected Object invokeUndefinedResult(ActionInvocation invocation, String resInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking undefined String Result [{}] at {}, use defaultObjectHandler [{}] ", new Object[]{resInfo, invocation.getActionProxy().getMethodInfo(), this.defaultObjectHandler});
        }
        return MethodUtil.invoke((AbstractProxy)this.defaultObjectHandler, (ActionInvocation)invocation);
    }

    public void setDefaultObjectHandler(ResultTypeProxy defaultObjectHandler) {
        this.defaultObjectHandler = defaultObjectHandler;
    }

    public void setObjectResultTypes(Map<Class, ResultTypeProxy> objectResultTypes) {
        this.objectResultTypes = objectResultTypes;
    }
}

