/*
 * Decompiled with CFR 0.152.
 */
package jrouter.servlet.filter;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import jrouter.ActionFactory;
import jrouter.NotFoundException;
import jrouter.config.Configuration;
import jrouter.impl.InvocationProxyException;
import jrouter.servlet.ServletActionFactory;
import jrouter.servlet.ServletThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRouterFilter
implements Filter {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected String encoding = null;
    private boolean trimRequestParameter = false;
    protected String configLocation = "jrouter.xml";
    protected boolean useThreadLocal = true;
    protected ActionFactory actionFactory;
    private boolean isServletActionFactory = false;
    private boolean logNotFoundException = true;
    protected ServletContext servletContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig filterConfig) {
        this.encoding = filterConfig.getInitParameter("encoding");
        String _trimRequestParameter = filterConfig.getInitParameter("trimRequestParameter");
        String conf = filterConfig.getInitParameter("configLocation");
        String factoryName = filterConfig.getInitParameter("factoryName");
        String _useThreadLocal = filterConfig.getInitParameter("useThreadLocal");
        String _logNotFoundException = filterConfig.getInitParameter("logNotFoundException");
        if (_useThreadLocal != null) {
            this.useThreadLocal = Boolean.parseBoolean(_useThreadLocal);
        }
        if (_trimRequestParameter != null) {
            this.trimRequestParameter = Boolean.parseBoolean(_trimRequestParameter);
        }
        if (conf != null) {
            this.configLocation = conf;
        }
        if (_logNotFoundException != null) {
            this.logNotFoundException = Boolean.parseBoolean(_logNotFoundException);
        }
        this.log.info("Set character encoding : " + this.encoding);
        this.servletContext = filterConfig.getServletContext();
        try {
            if (this.useThreadLocal) {
                ServletThreadContext.setServletContext(this.servletContext);
            }
            this.actionFactory = this.createActionFactory(filterConfig);
            if (factoryName != null) {
                this.servletContext.setAttribute(factoryName, (Object)this.actionFactory);
                this.log.info("Set ActionFactory's name in ServletContext : " + factoryName);
            }
            this.isServletActionFactory = this.actionFactory instanceof ServletActionFactory;
        }
        finally {
            if (this.useThreadLocal) {
                ServletThreadContext.remove();
            }
        }
    }

    protected ActionFactory createActionFactory(FilterConfig filterConfig) {
        this.log.info("Load configuration location : " + this.configLocation);
        Configuration configuration = new Configuration();
        configuration.load(this.configLocation);
        return configuration.buildActionFactory();
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        Map map;
        Object request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.encoding != null) {
            request.setCharacterEncoding(this.encoding);
            response.setCharacterEncoding(this.encoding);
        }
        if (this.trimRequestParameter && (map = request.getParameterMap()) != null && !map.isEmpty()) {
            request = new TrimParameterRequestWraper((HttpServletRequest)request);
        }
        if (this.useThreadLocal) {
            this.createServletThreadContext((HttpServletRequest)request, response);
        }
        try {
            if (this.isServletActionFactory) {
                ((ServletActionFactory)this.actionFactory).invokeAction(this.getActionPath((HttpServletRequest)request), (HttpServletRequest)request, response, this.servletContext);
            } else {
                this.actionFactory.invokeAction((Object)this.getActionPath((HttpServletRequest)request), new Object[0]);
            }
            if (!response.isCommitted()) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (NotFoundException e) {
            if (this.logNotFoundException) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            response.sendError(404, e.getMessage());
        }
        catch (InvocationProxyException e) {
            throw new ServletException(e.getSource());
        }
        finally {
            if (this.useThreadLocal) {
                ServletThreadContext.remove();
            }
        }
    }

    protected String getActionPath(HttpServletRequest request) {
        return request.getServletPath();
    }

    protected void createServletThreadContext(HttpServletRequest request, HttpServletResponse response) {
        ServletThreadContext.setRequest(request);
        ServletThreadContext.setResponse(response);
    }

    public void destroy() {
        if (this.actionFactory != null) {
            this.actionFactory.clear();
        }
        ServletThreadContext.remove();
    }

    private static final class TrimParameterRequestWraper
    extends HttpServletRequestWrapper {
        public TrimParameterRequestWraper(HttpServletRequest request) {
            super(request);
        }

        public String getParameter(String name) {
            String val = super.getParameter(name);
            if (val != null) {
                val = val.trim();
            }
            return val;
        }
    }
}

