/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.service.impl.esf;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.jplugin.core.config.api.ConfigFactory;
import net.jplugin.core.kernel.api.Extension;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContextManager;
import net.jplugin.core.service.api.ServiceFactory;
import net.jplugin.core.service.impl.esf.ESFRPCContext;
import net.jplugin.core.service.impl.esf.ESFRPCRquestInfoFillerBasic;
import net.jplugin.core.service.impl.esf.api.IRPCHandler;

public class ESFHelper2 {
    static boolean init = false;
    static Map<String, Object> objectsMap = null;
    public static int SERVICE_TIME_LIMIT = 6000;
    static IRPCHandler rpcHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() {
        if (init) return;
        Class<ESFHelper2> clazz = ESFHelper2.class;
        synchronized (ESFHelper2.class) {
            if (init) return;
            List<Extension> list = PluginEnvirement.getInstance().getExtensionList("EP_SERVICE_EXPORT");
            for (Extension ext : list) {
                ServiceFactory._addMapping("", ext.getObject(), ext.getFactory().getImplClass());
            }
            objectsMap = PluginEnvirement.getInstance().getExtensionMap("EP_SERVICE_EXPORT");
            init = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void setRPCHandler(IRPCHandler h) {
        rpcHandler = h;
    }

    public static Object invokeRPC(ESFRPCContext ctx, String servicePath, Object obj, Method method, Object[] args) throws Throwable {
        return rpcHandler.invokeRPC(ctx, servicePath, obj, method, args);
    }

    public static Object getObject(String uri) {
        ESFHelper2.init();
        return objectsMap.get(uri);
    }

    public static Map<String, Object> getObjectsMap() {
        ESFHelper2.init();
        return Collections.unmodifiableMap(objectsMap);
    }

    private static void checkTimeOut(long msgReceiveTime) {
        if (msgReceiveTime > 0L && System.currentTimeMillis() - msgReceiveTime > (long)SERVICE_TIME_LIMIT) {
            throw new RuntimeException("\u6267\u884c\u8d85\u65f6. limit=" + SERVICE_TIME_LIMIT);
        }
    }

    static {
        SERVICE_TIME_LIMIT = ConfigFactory.getIntConfig("platform.service-time-limit", 6000);
        PluginEnvirement.getInstance().getStartLogger().log("$$$ platform.service-time-limit is " + SERVICE_TIME_LIMIT);
        rpcHandler = new DefaultRpcHandler();
    }

    public static class DefaultRpcHandler
    implements IRPCHandler {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invokeRPC(ESFRPCContext ctx, String servicePath, Object obj, Method method, Object[] args) throws Throwable {
            try {
                ThreadLocalContextManager.instance.createContext();
                ESFHelper2.checkTimeOut(ctx.getMsgReceiveTime());
                ESFRPCRquestInfoFillerBasic.fill(ctx);
                Object object = method.invoke(obj, args);
                return object;
            }
            finally {
                ThreadLocalContextManager.instance.releaseContext();
            }
        }
    }
}

