/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.service.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jplugin.common.kits.StringKit;
import net.jplugin.common.kits.tuple.Tuple2;
import net.jplugin.core.kernel.api.Extension;
import net.jplugin.core.kernel.api.PluginEnvirement;

public class ServiceFactory {
    public static <T> T getService(String name, Class<T> clazz) {
        Object o = _GlobalServiceHolder.get(name);
        if (o == null) {
            throw new RuntimeException("Service not found for name:" + name);
        }
        if (o.getClass().isArray()) {
            StringBuffer sb = new StringBuffer("found multiple service for [" + name + "] :");
            Object[] arr = (Object[])o;
            for (int i = 0; i < arr.length; ++i) {
                sb.append("\n\t\t").append("[").append(i + 1).append("]:");
                sb.append(((Class)((Tuple2)arr[i]).second).getName()).append(",");
            }
            throw new RuntimeException(sb.toString());
        }
        return (T)((Tuple2)o).first;
    }

    public static <T> T getService(Class<T> clazz) {
        return ServiceFactory.getService(clazz.getName(), clazz);
    }

    public static void initExtensions(List<Extension> list) {
        for (Extension e : list) {
            ServiceFactory._addMapping(e.getName(), e.getObject(), e.getFactory().getImplClass());
        }
    }

    public static void _addMapping(String name, Object o, Class objectType) {
        if (PluginEnvirement.INSTANCE.getStateLevel() > 25) {
            throw new RuntimeException("can't call");
        }
        _GlobalServiceHolder.addMapping(name, Tuple2.with(o, objectType));
    }

    public static class _GlobalServiceHolder {
        public static Map<String, Object> map = new HashMap<String, Object>();

        public static Object get(String name) {
            return map.get(name);
        }

        public static void addMapping(String name, Tuple2<Object, Class> svcInfo) {
            if (((Class)svcInfo.second).isArray()) {
                throw new RuntimeException("Array service is not supported. " + ((Class)svcInfo.second).getName());
            }
            if (svcInfo.first == null) {
                throw new RuntimeException("null object.");
            }
            if (StringKit.isNotNull(name)) {
                _GlobalServiceHolder.add(name, svcInfo);
            } else {
                List<String> names = _GlobalServiceHolder.getNames((Class)svcInfo.second);
                for (String n : names) {
                    _GlobalServiceHolder.add(n, svcInfo);
                }
            }
        }

        private static List<String> getNames(Class<?> clazz) {
            ArrayList<String> list = new ArrayList<String>(4);
            list.add(clazz.getName());
            Class<?>[] interfaces = clazz.getInterfaces();
            Arrays.stream(interfaces).forEach(c -> {
                if (!c.getName().startsWith("java.")) {
                    list.add(c.getName());
                }
            });
            return list;
        }

        private static void add(String name, Tuple2<Object, Class> objInfo) {
            Object value = map.get(name);
            if (value != null) {
                if (value.getClass().isArray()) {
                    map.put(name, _GlobalServiceHolder.expandArray((Object[])value, objInfo));
                } else {
                    map.put(name, new Object[]{value, objInfo});
                }
            } else {
                map.put(name, objInfo);
            }
        }

        private static Object[] expandArray(Object[] arr, Object obj) {
            Object[] newarr = new Object[arr.length + 1];
            for (int i = 0; i < arr.length; ++i) {
                newarr[i] = arr[i];
            }
            newarr[arr.length] = obj;
            return newarr;
        }
    }
}

