/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.service;

import java.lang.annotation.Annotation;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.kernel.api.AbstractPlugin;
import net.jplugin.core.kernel.api.Extension;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.kernel.api.extfactory.ObjectFactory;
import net.jplugin.core.kernel.kits.ExtensionBindKit;
import net.jplugin.core.service.api.BindService;
import net.jplugin.core.service.api.BindServiceSet;

public class ExtensionServiceHelper {
    public static void addServiceExtension(AbstractPlugin plugin, Class impl) {
        plugin.addExtension(Extension.create("EP_SERVICE", impl));
    }

    public static void addServiceExtension(AbstractPlugin plugin, String name, Class impl) {
        plugin.addExtension(Extension.create("EP_SERVICE", name, impl));
    }

    public static void addServiceExtension(AbstractPlugin plugin, Class intf, Class impl) {
        ObjectFactory f = ObjectFactory.createFactory(impl);
        plugin.addExtension(Extension.create("EP_SERVICE", intf.getName(), f));
    }

    @Deprecated
    public static void addServiceExportExtension(AbstractPlugin plugin, String path, Class beanClz) {
        ExtensionServiceHelper.addExportServiceExtension(plugin, path, beanClz);
    }

    public static void addExportServiceExtension(AbstractPlugin plugin, String path, Class beanClz) {
        ObjectFactory factory = ObjectFactory.createFactory(beanClz);
        plugin.addExtension(Extension.create("EP_SERVICE_EXPORT", path, factory));
    }

    public static void autoBindServiceExtension(AbstractPlugin p, String pkgPath) {
        for (Class c : p.filterContainedClasses(pkgPath, BindService.class)) {
            BindService anno = c.getAnnotation(BindService.class);
            ExtensionServiceHelper.handleOneBind(p, c, anno);
        }
        for (Class c : p.filterContainedClasses(pkgPath, BindServiceSet.class)) {
            Annotation[] annos;
            for (Annotation a : annos = c.getAnnotationsByType(BindService.class)) {
                ExtensionServiceHelper.handleOneBind(p, c, a);
            }
        }
    }

    private static void handleOneBind(AbstractPlugin p, Class c, Annotation a) {
        BindService anno = (BindService)a;
        String name = anno.name();
        if (StringKit.isNull(name)) {
            ExtensionServiceHelper.addServiceExtension(p, c);
        } else {
            ExtensionServiceHelper.addServiceExtension(p, name, c);
        }
        PluginEnvirement.INSTANCE.getStartLogger().log("$$$ Auto add extension for service: interface= impl=" + c.getName());
        ExtensionBindKit.handleIdAndPriority(p, c);
    }

    private static Class computeInterfaceCls(Class impClazz) {
        Class<?>[] clazzs = impClazz.getInterfaces();
        if (clazzs.length == 0) {
            return impClazz;
        }
        if (clazzs.length > 1) {
            throw new RuntimeException("Class with multiple interfaces, must specify one interface in annotation. " + impClazz.getName());
        }
        return clazzs[0];
    }
}

