/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.rclient.proxyfac;

import java.util.Hashtable;
import java.util.Map;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.rclient.api.ClientFactory;
import net.jplugin.core.rclient.api.ClientInfo;
import net.jplugin.core.rclient.proxyfac.ClientProxyDefinition;

public class ClientProxyFactory {
    public static ClientProxyFactory instance = new ClientProxyFactory();
    Map<String, Object> objectMap = new Hashtable<String, Object>();
    private Map<String, ClientProxyDefinition> defMap;

    public void init() {
        this.defMap = PluginEnvirement.getInstance().getExtensionMap("EP_CLIENT_PROXY", ClientProxyDefinition.class);
    }

    public <T> T getClientProxy(Class<T> interf) {
        return this.getClientProxy(interf.getName(), interf);
    }

    public <T> T getClientProxy(String localName, Class<T> interf) {
        Object ret = this.objectMap.get(localName);
        if (ret == null) {
            ClientProxyDefinition def = this.defMap.get(localName);
            if (def == null) {
                throw new RuntimeException("Can't find the proxy definition: localName =" + localName);
            }
            ClientInfo ci = new ClientInfo();
            ci.setAppId(def.getAppId());
            ci.setAppToken(def.getAppToken());
            ret = ClientFactory.create(interf, def.getUrl(), def.getProtocol(), ci).getObject();
            this.objectMap.put(localName, ret);
        }
        return (T)ret;
    }
}

