/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.rclient.handler;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.jplugin.core.rclient.api.Client;
import net.jplugin.core.rclient.api.ClientCallContext;
import net.jplugin.core.rclient.api.IClientHandler;
import net.jplugin.core.rclient.handler.ClientFilterRegistry;
import net.jplugin.core.rclient.handler.ClientHandlerRegistry;

public class ClientProxyUtil {
    public static <T> T createProxyObject(final Client<T> c) {
        return (T)Proxy.newProxyInstance(c.getInterfaceClazz().getClassLoader(), new Class[]{c.getInterfaceClazz()}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                ClientCallContext ctx = ClientCallContext.create(c, proxy, method, args);
                ClientFilterRegistry.instance.filterStart(ctx);
                try {
                    IClientHandler handler = ClientHandlerRegistry.instance.getClientHandler(c.getProtocal());
                    Object ret = handler.invoke(c, proxy, method, args);
                    ctx.setReturnObject(ret);
                    Object object = ret;
                    return object;
                }
                catch (Throwable th) {
                    ctx.setThrowable(th);
                    if (th instanceof RuntimeException) {
                        throw (RuntimeException)th;
                    }
                    if (th instanceof InvocationTargetException) {
                        throw ((InvocationTargetException)th).getTargetException();
                    }
                    throw new RuntimeException(th);
                }
                finally {
                    ClientFilterRegistry.instance.filterEnd(ctx);
                }
            }
        });
    }
}

