/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.kernel.kits;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.jplugin.core.kernel.kits.RunnableWrapper;
import net.jplugin.core.kernel.kits.scheduled.ScheduledExecutorServiceWrapper;

public final class ExecutorKit {
    private static int maxQueueSize = 100000;
    private static int maxCachedThreadNum = 2000;

    public static ExecutorService newFixedThreadPool(int nThreads) {
        return new TheadLocalContextExecutorService(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(maxQueueSize));
    }

    public static ExecutorService newFixedThreadPool(int nThreads, ThreadFactory threadFactory) {
        return new TheadLocalContextExecutorService(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(maxQueueSize), threadFactory);
    }

    public static ExecutorService newFixedThreadPool(int nThreads, ThreadFactory threadFactory, int queueSize) {
        return new TheadLocalContextExecutorService(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), threadFactory);
    }

    public static ExecutorService newSingleThreadExecutor() {
        return new TheadLocalContextExecutorService(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(maxQueueSize));
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory) {
        return new TheadLocalContextExecutorService(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(maxQueueSize), threadFactory);
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory, int queueSize) {
        return new TheadLocalContextExecutorService(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), threadFactory);
    }

    public static ExecutorService newCachedThreadPool() {
        return new TheadLocalContextExecutorService(0, maxCachedThreadNum, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    public static ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return new TheadLocalContextExecutorService(0, maxCachedThreadNum, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newCachedThreadPool(ThreadFactory threadFactory, int maxThreadNum) {
        return new TheadLocalContextExecutorService(0, maxThreadNum, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor() {
        return new ScheduledExecutorServiceWrapper(Executors.newSingleThreadScheduledExecutor());
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory) {
        return new ScheduledExecutorServiceWrapper(Executors.newSingleThreadScheduledExecutor(threadFactory));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize) {
        return new ScheduledExecutorServiceWrapper(Executors.newScheduledThreadPool(corePoolSize));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory) {
        return new ScheduledExecutorServiceWrapper(Executors.newScheduledThreadPool(corePoolSize, threadFactory));
    }

    private ExecutorKit() {
    }

    private static class TheadLocalContextExecutorService
    extends ThreadPoolExecutor {
        public TheadLocalContextExecutorService(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        }

        public TheadLocalContextExecutorService(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        }

        @Override
        public void execute(Runnable command) {
            super.execute(new RunnableWrapper(command));
        }
    }
}

