/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.kernel.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import net.jplugin.common.kits.ReflactKit;
import net.jplugin.core.kernel.api.IAnnoForAttrHandler;
import net.jplugin.core.kernel.api.IObjectResolver;
import net.jplugin.core.kernel.api.PluginEnvirement;

public class DefaultObjectResolver
implements IObjectResolver {
    private IAnnoForAttrHandler[] handlers;
    private Class[] annoClassArr;

    private void init() {
        this.handlers = PluginEnvirement.getInstance().getExtensionPoint("EP_ANNO_FOR_ATTR").getExtensionObjects(IAnnoForAttrHandler.class);
        this.annoClassArr = new Class[this.handlers.length];
        for (int i = 0; i < this.handlers.length; ++i) {
            this.annoClassArr[i] = this.handlers[i].getAnnoClass();
        }
    }

    @Override
    public void resolve(Object obj) {
        if (this.handlers == null) {
            this.init();
        }
        if (String.class.equals(obj.getClass())) {
            return;
        }
        List<Field> fields = ReflactKit.getAllFields(obj);
        for (Field field : fields) {
            for (int i = 0; i < this.annoClassArr.length; ++i) {
                if (!field.isAnnotationPresent(this.annoClassArr[i])) continue;
                try {
                    this.handleAnnoted(obj, field, this.handlers[i]);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error when resolve annotation ref: class =" + obj.getClass().getName() + "  field=" + field.getName() + "   Caused by:" + e.getMessage(), e);
                }
            }
        }
    }

    private void handleAnnoted(Object obj, Field field, IAnnoForAttrHandler h) {
        Object oldV = ReflactKit.getFieldValueForce(field, obj);
        if (oldV != null) {
            if (Modifier.isStatic(field.getModifiers())) {
                return;
            }
            throw new RuntimeException("None static JPlugin annotated attribute value must be init as null." + obj.getClass().getName());
        }
        if (!h.getAttrClass().isAssignableFrom(field.getType())) {
            throw new RuntimeException("The type of annotated attribute " + h.getAnnoClass().getName() + " must be subclass of " + h.getAttrClass() + " ," + obj.getClass().getName() + "." + field.getName());
        }
        Object anno = field.getAnnotation(h.getAnnoClass());
        Object newV = h.getValue(obj, field.getType(), field, anno);
        if (newV == null) {
            throw new RuntimeException("Annotated attribute value retrived null: " + h.getAnnoClass().getName() + " ," + obj.getClass().getName() + "." + field.getName());
        }
        ReflactKit.setFieldValueForce(field, obj, newV);
    }
}

