/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.kernel.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.jplugin.core.kernel.api.IAnnoForAttrHandler;
import net.jplugin.core.kernel.api.IObjectResolver;
import net.jplugin.core.kernel.api.Initializable;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.kernel.impl.DefaultObjectResolver;

public class AnnotationResolveHelper {
    IObjectResolver defaultResolver;
    IObjectResolver extraResolver = null;
    private List<Object> toResolveList = new LinkedList<Object>();
    private List<Object> extraToResolveList = new LinkedList<Object>();
    private PluginEnvirement pluginEnvirement;
    private List<Object> toInitingList = new LinkedList<Object>();

    public AnnotationResolveHelper(PluginEnvirement pe) {
        this.pluginEnvirement = pe;
        this.defaultResolver = new DefaultObjectResolver();
    }

    public void initHistory() {
        for (Object o : this.toInitingList) {
            ((Initializable)o).initialize();
        }
        this.toInitingList.clear();
        this.toInitingList = null;
    }

    public void addObjectResolver(IObjectResolver ior) {
        if (PluginEnvirement.getInstance().getStateLevel() >= 27) {
            throw new RuntimeException("Resolver must be added before state:STAT_LEVEL_RESOLVING_HIST");
        }
        if (this.extraResolver != null) {
            throw new RuntimeException("addObjectResolver can't call twice");
        }
        this.extraResolver = ior;
    }

    public void resolveHistory() {
        HashSet<Object> set = new HashSet<Object>();
        for (Object o : this.toResolveList) {
            if (set.contains(o)) continue;
            set.add(o);
            this.resolveOne(o);
        }
        set.clear();
        this.toResolveList.clear();
        this.toResolveList = null;
    }

    public void resolveHistoryForExtraResolver() {
        for (Object o : this.extraToResolveList) {
            this.extraResolver.resolve(o);
        }
        this.extraToResolveList.clear();
        this.extraToResolveList = null;
    }

    public final void valid() {
        IAnnoForAttrHandler[] handlers = PluginEnvirement.getInstance().getExtensionPoint("EP_ANNO_FOR_ATTR").getExtensionObjects(IAnnoForAttrHandler.class);
        HashSet checkSet = new HashSet();
        for (IAnnoForAttrHandler h : handlers) {
            if (checkSet.contains(h.getAnnoClass())) {
                throw new RuntimeException("Duplicate handler for annotation class:" + h.getAnnoClass().getName());
            }
            checkSet.add(h.getAnnoClass());
        }
    }

    public final void resolveBatch(Collection<Object> objList) {
        if (objList == null) {
            return;
        }
        for (Object obj : objList) {
            this.resolveOne(obj);
        }
    }

    public final void resolveOne(Object obj) {
        if (this.pluginEnvirement.getStateLevel() < 27) {
            this.toResolveList.add(obj);
            return;
        }
        this.defaultResolver.resolve(obj);
        if (this.extraResolver != null) {
            if (this.pluginEnvirement.getStateLevel() == 27) {
                this.extraToResolveList.add(obj);
            } else {
                this.extraResolver.resolve(obj);
            }
        }
        if (obj instanceof Initializable) {
            if (this.pluginEnvirement.getStateLevel() < 30) {
                this.toInitingList.add(obj);
            } else {
                ((Initializable)obj).initialize();
            }
        }
    }
}

