/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.kernel.api.ctx;

import net.jplugin.core.kernel.api.ctx.RequesterInfo;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContext;

public class ThreadLocalContextManager {
    ThreadLocal<ThreadLocalContext> ctxLocal = new ThreadLocal();
    public static ThreadLocalContextManager instance = new ThreadLocalContextManager();

    public static RequesterInfo getRequestInfo() {
        return instance.getContext().getRequesterInfo();
    }

    public static ThreadLocalContext getCurrentContext() {
        return instance.getContext();
    }

    public ThreadLocalContext getContext() {
        ThreadLocalContext ctx = this.ctxLocal.get();
        return ctx;
    }

    public ThreadLocalContext createContext() {
        if (this.ctxLocal.get() != null) {
            throw new RuntimeException("Ctx state not right!");
        }
        ThreadLocalContext rc = new ThreadLocalContext();
        this.ctxLocal.set(rc);
        return rc;
    }

    public boolean createContextIfNotExists() {
        if (this.ctxLocal.get() == null) {
            this.createContext();
            return true;
        }
        return false;
    }

    public void releaseContext() {
        ThreadLocalContext ctx = this.ctxLocal.get();
        if (ctx == null) {
            throw new RuntimeException("Can't find ctx!");
        }
        this.ctxLocal.set(null);
        ctx.release();
    }

    public static void runInContext(Runnable r) {
        boolean b = false;
        try {
            b = instance.createContextIfNotExists();
            r.run();
        }
        finally {
            if (b) {
                instance.releaseContext();
            }
        }
    }
}

