/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.kernel.api;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.jplugin.common.kits.StringKit;
import net.jplugin.common.kits.reso.ResolverKit;
import net.jplugin.core.kernel.api.PluginAnnotation;

public class PluginAutoDetect {
    private static Set<String> pkgPrepfixes = new HashSet<String>();

    public static Collection<? extends Object> get(Set<Object> old) {
        PluginAutoDetect.addAutoDetectFromSysProperty();
        if (pkgPrepfixes.size() == 0) {
            return new HashSet();
        }
        System.out.println("Auto Detect plugins from :" + pkgPrepfixes);
        return PluginAutoDetect.autoDetect(old);
    }

    private static void addAutoDetectFromSysProperty() {
        String[] path;
        String property = System.getProperty("plugin-auto-detect");
        if (property == null) {
            return;
        }
        for (String p : path = StringKit.splitStr(property, ",")) {
            PluginAutoDetect.addAutoDetectPackage(p);
        }
    }

    public static void addAutoDetectPackage(String pkg) {
        pkgPrepfixes.add(pkg);
    }

    private static Collection<? extends Object> autoDetect(Set<Object> old) {
        if (pkgPrepfixes.isEmpty()) {
            return new HashSet();
        }
        ResolverKit rk = new ResolverKit();
        String[] arr = new String[pkgPrepfixes.size()];
        rk.findAnnotated(PluginAnnotation.class, pkgPrepfixes.toArray(arr));
        Set clazz = rk.getClasses();
        HashSet<String> ret = new HashSet<String>();
        for (Class c : clazz) {
            String name;
            PluginAnnotation ann = c.getAnnotation(PluginAnnotation.class);
            if (ann == null || !ann.autoDetect() || old.contains(name = c.getName())) continue;
            ret.add(name);
        }
        System.out.println("Auto Detect plugins:" + ret);
        return ret;
    }
}

