/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.kernel.api;

import net.jplugin.common.kits.AssertKit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.kernel.api.IExtensionFactory;
import net.jplugin.core.kernel.api.IPropertyFilter;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.kernel.api.extfactory.ObjectFactory;
import net.jplugin.core.kernel.api.extfactory.StringExtensionFactory;

public class Extension {
    public static IPropertyFilter propertyFilter = null;
    static Extension lastAdded = null;
    private String refExtensionPoint;
    private String name;
    private IExtensionFactory factory;
    private int priority;
    Object extensionObject;
    private String id;

    void setRefExtensionPoint(String nm) {
        if (StringKit.isNotNull(this.refExtensionPoint)) {
            throw new RuntimeException("can't set");
        }
        this.refExtensionPoint = nm;
    }

    public static void setLastExtensionId(String id) {
        if (lastAdded == null) {
            throw new RuntimeException("Last extension is null.");
        }
        lastAdded.setId(id);
    }

    public static void setLastExtensionPriority(int priority) {
        if (lastAdded == null) {
            throw new RuntimeException("Last extension is null.");
        }
        lastAdded.setPriority(priority);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("refPoint:" + this.refExtensionPoint + " clazz:" + this.factory.getImplClass().getName() + " name:" + this.name);
        sb.append(" factory:[").append(this.factory).append("]");
        return sb.toString();
    }

    public int hashCode() {
        return (this.refExtensionPoint + this.name).hashCode();
    }

    public IExtensionFactory getFactory() {
        return this.factory;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Extension)) {
            return false;
        }
        Extension e = (Extension)obj;
        return this.refExtensionPoint.equals(e.refExtensionPoint) && StringKit.eqOrNull(this.name, e.name) && this.factory.contentEqual(e.factory) && StringKit.eqOrNull(this.id, e.id);
    }

    public String getExtensionPointName() {
        return this.refExtensionPoint;
    }

    public String getName() {
        return this.name;
    }

    public Class getClazz() {
        return this.factory.getImplClass();
    }

    public Object getObject() {
        return this.extensionObject;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public synchronized void load() throws Exception {
        this.extensionObject = this.factory.create(this);
        if (!(this.extensionObject instanceof String)) {
            PluginEnvirement.getInstance().resolveRefAnnotation(this.extensionObject);
        }
    }

    public static Extension createStringExtension(String aPointName, String value) {
        return Extension.create(aPointName, "", StringExtensionFactory.createFactory(value));
    }

    public static Extension create(String aPointName, Class cls) {
        return Extension.create(aPointName, "", cls);
    }

    public static Extension create(String aPointName, String aName, Class cls) {
        return Extension.create(aPointName, aName, ObjectFactory.createFactory(cls));
    }

    public static Extension create(String aPointName, Class cls, String[][] property) {
        if (cls.equals(String.class)) {
            throw new RuntimeException("Please call createStrignExtension");
        }
        return Extension.create(aPointName, ObjectFactory.createFactory(cls, property));
    }

    public static Extension create(String aPointName, IExtensionFactory fac) {
        return Extension.create(aPointName, "", fac);
    }

    public static Extension create(String aPointName, String aName, Class cls, String[][] property) {
        if (cls.equals(String.class)) {
            throw new RuntimeException("Please call createStrignExtension");
        }
        return Extension.create(aPointName, aName, ObjectFactory.createFactory(cls, property));
    }

    public static Extension create(String aPointName, String aName, IExtensionFactory fac) {
        Extension ext = new Extension();
        ext.name = aName;
        ext.refExtensionPoint = aPointName;
        ext.factory = fac;
        return ext;
    }

    public String getId() {
        return this.id;
    }

    void setId(String o) {
        this.id = o;
    }

    public static void main(String[] args) {
        Extension e1 = Extension.create("a", Extension.class, new String[][]{{"a1", "b1"}, {"a2", "v2"}});
        Extension e2 = Extension.create("a", Extension.class, new String[][]{{"a1", "b1"}, {"a2", "v2"}});
        AssertKit.assertTrue(e1.equals(e2));
        e1 = Extension.create("a", Extension.class, new String[][]{{"a1", "b1"}, {"a2", "v2"}});
        e2 = Extension.create("a", Extension.class, new String[][]{{"a1", "b1"}, {"a2", "v3"}});
        AssertKit.assertFalse(e1.equals(e2));
        e1 = Extension.create("a", null, Extension.class, new String[][]{{"a1", "b1"}, {"a2", "v2"}});
        e2 = Extension.create("a", null, Extension.class, new String[][]{{"a1", "b1"}, {"a2", "v2"}});
        AssertKit.assertTrue(e1.equals(e2));
        e1 = Extension.create("a", null, Extension.class, new String[][]{{"a1", "b1"}, {"a2", "v2"}});
        e2 = Extension.create("a", "b", Extension.class, new String[][]{{"a1", "b1"}, {"a2", "v2"}});
        AssertKit.assertFalse(e1.equals(e2));
        e1 = Extension.create("a", Extension.class);
        e2 = Extension.create("a", Extension.class);
        AssertKit.assertTrue(e1.equals(e2));
        e1 = Extension.create("a", Extension.class);
        e2 = Extension.create("a", Extension.class);
        AssertKit.assertTrue(e1.equals(e2));
    }
}

