/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.kernel.api;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jplugin.common.kits.AssertKit;
import net.jplugin.common.kits.ReflactKit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.common.kits.reso.ResolverKit;
import net.jplugin.core.kernel.api.AutoBindExtensionManager;
import net.jplugin.core.kernel.api.Extension;
import net.jplugin.core.kernel.api.ExtensionPoint;
import net.jplugin.core.kernel.api.IBindExtensionHandler;
import net.jplugin.core.kernel.api.IClassChecker;
import net.jplugin.core.kernel.api.IExtensionFactory;
import net.jplugin.core.kernel.api.IPlugin;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.kernel.api.PluginError;
import net.jplugin.core.kernel.api.PluginRegistry;

public abstract class AbstractPlugin
implements IPlugin {
    private List<ExtensionPoint> extensionPoints = new ArrayList<ExtensionPoint>();
    private List<Extension> extensions = new ArrayList<Extension>();
    private String pluginName = this.getClass().getName();
    private int status = 0;
    private Hashtable<String, String> configreus = new Hashtable();
    private Set<Class> containedClasses = null;

    public AbstractPlugin() {
        if (this.searchClazzForExtension()) {
            List<IBindExtensionHandler> handlers = AutoBindExtensionManager.INSTANCE.getHandlers();
            for (IBindExtensionHandler h : handlers) {
                h.handle(this);
            }
        }
    }

    public String printContent() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append("\n  ExtensionPoints(").append(this.extensionPoints.size()).append(") :");
        for (i = 0; i < this.extensionPoints.size(); ++i) {
            ExtensionPoint p = this.extensionPoints.get(i);
            sb.append("\n    ");
            sb.append(p.getName() + "  { type=" + (Object)((Object)p.getType()) + " , baseCalss=" + p.getExtensionClass().getName());
            if (p.supportPriority()) {
                sb.append("  SUPPORT_PRIORITY");
            }
            sb.append(" }");
        }
        sb.append("\n  Extensions(").append(this.extensions.size()).append(") :");
        for (i = 0; i < this.extensions.size(); ++i) {
            Extension e = this.extensions.get(i);
            sb.append("\n    ").append("[ pointTo=");
            sb.append(e.getExtensionPointName()).append(" , ");
            sb.append("implClass=").append(e.getClazz().getName()).append(" , name=").append(e.getName());
            if (StringKit.isNotNull(e.getId())) {
                sb.append("  id=").append(e.getId());
            }
            if (e.getPriority() != 0) {
                sb.append("  priority=" + e.getPriority());
            }
            sb.append(" ]");
        }
        return sb.toString();
    }

    @Override
    public void onCreateServices() {
    }

    public boolean searchClazzForExtension() {
        return true;
    }

    @Deprecated
    protected void searchAndBindExtensions() {
    }

    public void addExtensionPoint(ExtensionPoint ep) {
        this.extensionPoints.add(ep);
    }

    public void addExtension(Extension e) {
        this.extensions.add(e);
        Extension.lastAdded = e;
    }

    public void addConfigure(String name, String val) {
        if (this.configreus.containsKey(name)) {
            throw new RuntimeException("duplicate config name:" + name);
        }
        this.configreus.put(name, val);
    }

    @Override
    public List<ExtensionPoint> getExtensionPoints() {
        return this.extensionPoints;
    }

    @Override
    public List<Extension> getExtensions() {
        return this.extensions;
    }

    @Override
    public String getName() {
        return this.pluginName;
    }

    @Override
    public abstract int getPrivority();

    @Override
    public int getStatus() {
        return this.status;
    }

    public List<PluginError> load() {
        try {
            List<PluginError> errList = null;
            if (this.status != 0) {
                throw new RuntimeException("Not init state,can't call load,plugin name:" + this.getName());
            }
            for (int i = 0; i < this.extensions.size(); ++i) {
                try {
                    this.extensions.get(i).load();
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("extension locad error." + this.extensions.get(i).getClazz() + " " + e.getMessage(), e);
                }
            }
            return errList;
        }
        catch (Exception e) {
            PluginEnvirement.getInstance().getStartLogger().log("load error, Plugin=" + this.getName() + "   msg=" + e.getMessage(), e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void wire(PluginRegistry pluginRegistry, List<PluginError> errorList) {
        int i;
        for (i = 0; i < this.getExtensionPoints().size(); ++i) {
            ExtensionPoint ep = this.getExtensionPoints().get(i);
            pluginRegistry.getExtensionPointMap().put(ep.getName(), ep);
        }
        for (i = 0; i < this.getExtensions().size(); ++i) {
            Extension e = this.getExtensions().get(i);
            String pname = e.getExtensionPointName();
            ExtensionPoint point = pluginRegistry.getExtensionPointMap().get(pname);
            if (point == null) {
                errorList.add(new PluginError(this.getName(), "Couldn't find extension point for extension ,perhaps the extensionpoint plugin is not load correctly.extension= " + e.getName() + " pointname=" + pname));
                continue;
            }
            String msg = point.validAndAddExtension(e);
            if (msg == null) continue;
            errorList.add(new PluginError(this.getName(), msg + "  ExtensionPoint=" + point.getName() + " ImplClazz=" + e.getClazz() + ", ExtensionName=" + e.getName()));
        }
    }

    public List<PluginError> valid(PluginRegistry pluginRegistry) {
        ArrayList<PluginError> errors = new ArrayList<PluginError>();
        for (ExtensionPoint ep : this.extensionPoints) {
            ExtensionPoint finder;
            if (StringKit.isNull(ep.getName())) {
                errors.add(new PluginError(this.getName(), "extension point name is null"));
            }
            if ((finder = pluginRegistry.getExtensionPointMap().get(ep.getName())) != null) {
                errors.add(new PluginError(this.getName(), "point name duplicated with old points:" + ep.getName()));
            }
            pluginRegistry.getExtensionPointMap().put(ep.getName(), ep);
        }
        for (Extension e : this.extensions) {
            String pname = e.getExtensionPointName();
            ExtensionPoint finder = pluginRegistry.getExtensionPointMap().get(pname);
            if (finder == null) {
                errors.add(new PluginError(this.getName(), "can't find extension point for:" + e.getName() + " pointname=" + pname));
                continue;
            }
            if (ReflactKit.isTypeOf(e.getClazz(), IExtensionFactory.class)) {
                Type paraArgType = ReflactKit.getParameterizedIntfArg(e.getClazz(), IExtensionFactory.class);
                Class paraArgClazz = (Class)paraArgType;
                if (paraArgClazz == null || ReflactKit.isTypeOf(paraArgClazz, finder.getExtensionClass())) continue;
                errors.add(new PluginError(this.getName(), "The parameterized type is not required type. extClass=" + e.getClazz() + " required=" + finder.getExtensionClass() + " point=" + pname));
                continue;
            }
            if (ReflactKit.isTypeOf(e.getClazz(), finder.getExtensionClass())) continue;
            errors.add(new PluginError(this.getName(), "The extension is not sub class of the point required. extClass=" + e.getClazz() + " required=" + finder.getExtensionClass() + " point=" + pname));
        }
        return errors;
    }

    public void setStatus(int st) {
        this.status = st;
    }

    @Override
    public Map<String, String> getConfigures() {
        return this.configreus;
    }

    @Override
    public void onDestroy() {
    }

    public Set<Class> getContainedClasses() {
        if (PluginEnvirement.INSTANCE.getStateLevel() > 30) {
            throw new RuntimeException("Can't call in working state");
        }
        if (this.containedClasses == null) {
            List<String> excludePackages = this.getExcludePackages();
            ResolverKit kit = new ResolverKit();
            if (excludePackages.isEmpty()) {
                kit.find(c -> true, this.getClass().getPackage().getName());
            } else {
                kit.find(c -> true, name -> {
                    for (String exclude : excludePackages) {
                        if (name.length() == exclude.length() || !name.startsWith(exclude)) continue;
                        return false;
                    }
                    return true;
                }, this.getClass().getPackage().getName());
            }
            this.containedClasses = kit.getClasses();
        }
        return this.containedClasses;
    }

    private List<String> getExcludePackages() {
        ArrayList<String> result = new ArrayList<String>(2);
        String myPkg = this.getClass().getPackage().getName();
        List<Class> list = PluginEnvirement.getInstance().getPluginRegistry().getPluginClasses();
        for (Class p : list) {
            if (this.getClass().equals(p)) continue;
            String pkgname = p.getPackage().getName();
            if (pkgname.equals(myPkg)) {
                throw new RuntimeException("Duplicate plugin found  in one single package. " + this.getClass().getName() + " | " + p.getClass().getName());
            }
            if (!pkgname.startsWith(myPkg)) continue;
            result.add(StringKit.replaceStr(pkgname, ".", "/"));
        }
        return result;
    }

    public Set<Class> filterContainedClassesByChecker(String pkgPath, IClassChecker checker) {
        AssertKit.assertTrue(StringKit.isNull(pkgPath) || pkgPath.startsWith("."));
        this.getContainedClasses();
        String prefix = this.getClass().getPackage().getName();
        prefix = StringKit.isNull(pkgPath) ? prefix + "." : prefix + pkgPath + ".";
        HashSet<Class> temp = new HashSet<Class>();
        for (Class c : this.containedClasses) {
            if (!c.getName().startsWith(prefix) || !checker.check(c)) continue;
            temp.add(c);
        }
        return temp;
    }

    public Set<Class> filterContainedClasses(String pkgPath, Class annoClazz) {
        return this.filterContainedClassesByChecker(pkgPath, c -> annoClazz == null || c.getAnnotation(annoClazz) != null);
    }

    public void _cleanContainedClasses() {
        if (this.containedClasses == null) {
            return;
        }
        this.containedClasses.clear();
        this.containedClasses = null;
    }

    public void afterPluginsContruct() {
    }

    public void afterPluginsLoad() {
    }

    public void afterWire() {
    }
}

