/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.config.impl;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.jplugin.common.kits.PropertiesKit;
import net.jplugin.core.config.api.IConfigProvidor;

public class ConfigRepository
implements IConfigProvidor {
    private static final String POSTFIX = ".config.properties";
    HashMap<String, String> configMap = new HashMap();
    Set<String> groups = new HashSet<String>();

    @Override
    public String getConfigValue(String key) {
        return this.configMap.get(key);
    }

    public void init(String cfgdir) {
        File[] files;
        for (File f : files = new File(cfgdir).listFiles()) {
            String fname = f.getName();
            if (!fname.endsWith(POSTFIX)) continue;
            String cfgSection = fname.substring(0, fname.length() - POSTFIX.length());
            this.load(f, cfgSection);
            this.groups.add(cfgSection);
        }
    }

    private void load(File f, String cfgSection) {
        Properties prop = PropertiesKit.loadProperties(f.getPath());
        for (Object k : prop.keySet()) {
            this.configMap.put(cfgSection + "." + (String)k, prop.getProperty((String)k));
        }
    }

    @Override
    public boolean containsConfig(String path) {
        return this.configMap.containsKey(path);
    }

    @Override
    public Map<String, String> getStringConfigInGroup(String group) {
        String prefix = group + ".";
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String k : this.configMap.keySet()) {
            if (!k.startsWith(prefix)) continue;
            ret.put(k.substring(group.length() + 1), this.configMap.get(k));
        }
        return ret;
    }

    @Override
    public Set<String> getGroups() {
        return this.groups;
    }
}

