/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.config.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.config.api.IConfigProvidor;
import net.jplugin.core.kernel.api.PluginEnvirement;

public class GlobalConfigFactory {
    private static IConfigProvidor remoteConfigProvidor = new EmptyProvidor();
    private static final String DEFAULT_GROUP = "DEFAULT_GROUP";

    public static String getValueInDefaultGroup(String path, String def) {
        return GlobalConfigFactory.getValue("DEFAULT_GROUP." + path, def);
    }

    public static String getValueInDefaultGroup(String path) {
        return GlobalConfigFactory.getValueInDefaultGroup(path, null);
    }

    public static String getValue(String path, String def) {
        String val = GlobalConfigFactory._getStringConfig(path);
        if (StringKit.isNull(val)) {
            return def;
        }
        return val;
    }

    public static String getValue(String path) {
        return GlobalConfigFactory.getValue(path, null);
    }

    public static String getValueWithTrim(String path) {
        String v = GlobalConfigFactory.getValue(path, null);
        if (v != null) {
            v = v.trim();
        }
        return v;
    }

    public static Set<String> getGroups() {
        return Collections.unmodifiableSet(remoteConfigProvidor.getGroups());
    }

    public static Map<String, String> getStringConfigInGroup(String group) {
        return remoteConfigProvidor.getStringConfigInGroup(group);
    }

    private static String _getStringConfig(String path) {
        return remoteConfigProvidor.getConfigValue(path);
    }

    public static void _setRemoteConfigProvidor(IConfigProvidor repo) {
        remoteConfigProvidor = repo;
        PluginEnvirement.INSTANCE.getStartLogger().log("$$$ Global Configigure Providor init:" + repo.getClass().getName());
    }

    static class EmptyProvidor
    implements IConfigProvidor {
        EmptyProvidor() {
        }

        @Override
        public String getConfigValue(String path) {
            return null;
        }

        @Override
        public boolean containsConfig(String path) {
            return false;
        }

        @Override
        public Map<String, String> getStringConfigInGroup(String group) {
            return new HashMap<String, String>();
        }

        @Override
        public Set<String> getGroups() {
            return new HashSet<String>();
        }
    }
}

