/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.config.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.jplugin.common.kits.AssertKit;
import net.jplugin.common.kits.FileKit;
import net.jplugin.common.kits.IpKit;
import net.jplugin.common.kits.PropertiesKit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.config.api.ConfigFactory;
import net.jplugin.core.kernel.api.PluginEnvirement;

public class CloudEnvironment {
    public static CloudEnvironment INSTANCE = new CloudEnvironment();
    public static final String NACOS_URL = "nacos-url";
    public static final String MODULE_CODE = "module-code";
    public static final String APP_CODE = "app-code";
    public static final String RPC_PORT = "rpc-port";
    public static final String NACOS_USER = "nacos-user";
    public static final String NACOS_PWD = "nacos-pwd";
    public static final String RPC_PORT_HINT_EMBED_TOMCAT = "-1";
    private String nacosUrl;
    private String appCode;
    private String moduleCode;
    private String rpcPort;
    private String nacosUser;
    private String nacosPwd;
    private String composedAppCode;
    private String boundIp;
    private boolean inited = false;

    private CloudEnvironment() {
    }

    public String getNacosUrl() {
        this.checkInit();
        return this.nacosUrl;
    }

    public String getNacosPwd() {
        return this.nacosPwd;
    }

    public String getRpcPort() {
        this.checkInit();
        return this.rpcPort;
    }

    public String getNacosUser() {
        return this.nacosUser;
    }

    public String getAppCode() {
        this.checkInit();
        return this.appCode;
    }

    public String getModuleCode() {
        this.checkInit();
        return this.moduleCode;
    }

    public String _composeAppCode() {
        this.checkInit();
        if (StringKit.isNull(this.composedAppCode)) {
            this.composedAppCode = this.appCode + ":" + this.moduleCode;
        }
        return this.composedAppCode;
    }

    public String getBoundIp() {
        this.checkInit();
        if (StringKit.isNull(this.boundIp)) {
            this.boundIp = IpKit.getLocalIp();
        }
        return this.boundIp;
    }

    public boolean hasInit() {
        return this.inited;
    }

    private void checkInit() {
        if (!this.inited) {
            throw new RuntimeException("init not called");
        }
    }

    public void init(Map<String, String> map) {
        String temp;
        if (this.inited) {
            PluginEnvirement.getInstance().getStartLogger().log("WARNNING: CloudEnvironment init called a second time\uff0cIgnored!");
        }
        AssertKit.assertStringNotNull(map.get(NACOS_URL), NACOS_URL);
        AssertKit.assertStringNotNull(map.get(APP_CODE), APP_CODE);
        AssertKit.assertStringNotNull(map.get(MODULE_CODE), MODULE_CODE);
        AssertKit.assertStringNotNull(map.get(RPC_PORT), RPC_PORT);
        this.nacosUrl = map.get(NACOS_URL).trim();
        this.appCode = map.get(APP_CODE).trim();
        this.moduleCode = map.get(MODULE_CODE).trim();
        this.rpcPort = map.get(RPC_PORT).trim();
        this.rpcPort = CloudEnvironment.handleForEmbbedTomcat(this.rpcPort);
        if (StringKit.isNotNull(this.appCode) && this.appCode.indexOf(":") >= 0) {
            AssertKit.assertNull(this.moduleCode);
            int pos = this.appCode.indexOf(":");
            String temp2 = this.appCode;
            this.appCode = temp2.substring(0, pos);
            this.moduleCode = temp2.substring(pos + 1);
        }
        if (StringKit.isNotNull(temp = map.get(NACOS_USER))) {
            this.nacosUser = temp.trim();
        }
        if (StringKit.isNotNull(temp = map.get(NACOS_PWD))) {
            this.nacosPwd = temp.trim();
        }
        this.inited = true;
        PluginEnvirement.getInstance().getStartLogger().log("$$$ CloudEnvironment Init: nacosUrl=" + this.nacosUrl + ", appCode=" + this.appCode + ", serviceCode=" + this.moduleCode + " nacosUser=" + this.nacosUser + " rpcPort=" + this.getRpcPort());
    }

    private static String handleForEmbbedTomcat(String rpcPort) {
        if (!RPC_PORT_HINT_EMBED_TOMCAT.equals(rpcPort)) {
            return rpcPort;
        }
        Integer intTomcatPort = ConfigFactory.getIntConfig("embed-tomcat.context-port", 8080);
        String esfport = intTomcatPort + 100 + "";
        return esfport;
    }

    private String arrToString(String[] serviceCodes) {
        StringBuffer sb = new StringBuffer();
        for (String s : serviceCodes) {
            sb.append(s).append(",");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(NACOS_URL, "url1");
        map.put(APP_CODE, "appcode1");
        map.put(MODULE_CODE, "S1,S2");
        INSTANCE.init(map);
        System.out.println(INSTANCE.getAppCode());
        System.out.println(INSTANCE.getNacosUrl());
        System.out.println(INSTANCE.getModuleCode());
    }

    public void loadFromConfig() {
        String cfgName = PluginEnvirement.getInstance().getConfigDir() + "/jplugin-cloud.properties";
        if (!FileKit.existsAndIsFile(cfgName)) {
            PluginEnvirement.getInstance().getStartLogger().log("$$$ jplugin-cloud.properties not found");
            return;
        }
        Properties prop = null;
        try {
            prop = PropertiesKit.loadProperties(cfgName);
        }
        catch (Exception e) {
            throw new RuntimeException("load jplugin-cloud.properties error");
        }
        Map<String, String> map = this.propertiesToMap(prop);
        INSTANCE.init(map);
        PluginEnvirement.getInstance().getStartLogger().log("$$$ CloudEnvironment init ok from jplugin-cloud.properties");
    }

    private Map<String, String> propertiesToMap(Properties prop) {
        HashMap<String, String> map = new HashMap<String, String>(0);
        for (Map.Entry<Object, Object> en : prop.entrySet()) {
            map.put((String)en.getKey(), (String)en.getValue());
        }
        return map;
    }
}

