/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.common.kits.reso;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jplugin.common.kits.reso.Logger;
import net.jplugin.common.kits.reso.VFS;

public class ResolverKit<T> {
    private static final Logger log = Logger.getLogger(ResolverKit.class);
    private Set<Class<? extends T>> matches = new HashSet<Class<? extends T>>();
    private ClassLoader classloader;

    public Set<Class<? extends T>> getClasses() {
        return this.matches;
    }

    public ClassLoader getClassLoader() {
        return this.classloader == null ? Thread.currentThread().getContextClassLoader() : this.classloader;
    }

    public void setClassLoader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public ResolverKit<T> findImplementations(Class<?> parent, String ... packageNames) {
        if (packageNames == null) {
            return this;
        }
        IsA test2 = new IsA(parent);
        for (String pkg : packageNames) {
            this.find(test2, pkg);
        }
        return this;
    }

    public ResolverKit<T> findAnnotated(Class<? extends Annotation> annotation, String ... packageNames) {
        if (packageNames == null) {
            return this;
        }
        AnnotatedWith test2 = new AnnotatedWith(annotation);
        for (String pkg : packageNames) {
            this.find(test2, pkg);
        }
        return this;
    }

    public ResolverKit<T> find(Test test2, String packageName) {
        String path = this.getPackagePath(packageName);
        try {
            List<String> children = VFS.getInstance().list(path);
            for (String child : children) {
                if (!child.endsWith(".class")) continue;
                this.addIfMatching(test2, child);
            }
        }
        catch (IOException ioe) {
            log.error("Could not read package: " + packageName, ioe);
        }
        return this;
    }

    public ResolverKit<T> find(Test test2, NameTest nt, String packageName) {
        String path = this.getPackagePath(packageName);
        try {
            List<String> children = VFS.getInstance().list(path, nt);
            for (String child : children) {
                if (!child.endsWith(".class")) continue;
                this.addIfMatching(test2, child);
            }
        }
        catch (IOException ioe) {
            log.error("Could not read package: " + packageName, ioe);
        }
        return this;
    }

    public ResolverKit<T> find(String packageName, Test test2) {
        return this.find(test2, packageName);
    }

    public ResolverKit<T> find(String packageName, Test ... test2) {
        String path = this.getPackagePath(packageName);
        try {
            List<String> children = VFS.getInstance().list(path);
            for (String child : children) {
                if (!child.endsWith(".class")) continue;
                this.addIfMatching(child, test2);
            }
        }
        catch (IOException ioe) {
            log.error("Could not read package: " + packageName, ioe);
        }
        return this;
    }

    protected String getPackagePath(String packageName) {
        return packageName == null ? null : packageName.replace('.', '/');
    }

    protected void addIfMatching(Test test2, String fqn) {
        try {
            String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
            ClassLoader loader = this.getClassLoader();
            log.debug("Checking to see if class " + externalName + " matches criteria [" + test2 + "]");
            Class<?> type = loader.loadClass(externalName);
            if (test2.matches(type)) {
                this.matches.add(type);
            }
        }
        catch (Throwable t) {
            log.warn("Could not examine class '" + fqn + "'" + " due to a " + t.getClass().getName() + " with message: " + t.getMessage());
        }
    }

    protected void addIfMatching(String fqn, Test ... test2) {
        try {
            String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
            ClassLoader loader = this.getClassLoader();
            log.debug("Checking to see if class " + externalName + " matches criteria [" + test2 + "]");
            Class<?> type = loader.loadClass(externalName);
            boolean flag = false;
            for (int i = 0; i < test2.length; ++i) {
                if (!test2[i].matches(type)) continue;
                flag = true;
                break;
            }
            if (flag) {
                this.matches.add(type);
            }
        }
        catch (Throwable t) {
            log.warn("Could not examine class '" + fqn + "'" + " due to a " + t.getClass().getName() + " with message: " + t.getMessage());
        }
    }

    public static class AnnotatedWith
    implements Test {
        private Class<? extends Annotation> annotation;

        public AnnotatedWith(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        @Override
        public boolean matches(Class<?> type) {
            return type != null && type.isAnnotationPresent(this.annotation);
        }

        public String toString() {
            return "annotated with @" + this.annotation.getSimpleName();
        }
    }

    public static class IsA
    implements Test {
        private Class<?> parent;

        public IsA(Class<?> parentType) {
            this.parent = parentType;
        }

        @Override
        public boolean matches(Class<?> type) {
            return type != null && this.parent.isAssignableFrom(type);
        }

        public String toString() {
            return "is assignable to " + this.parent.getSimpleName();
        }
    }

    public static interface NameTest {
        public boolean matchsName(String var1);
    }

    public static interface Test {
        public boolean matches(Class<?> var1);
    }
}

