/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.common.kits;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringKit {
    static final String[] SBC = new String[]{"\uff0c", "\u3002", "\uff1b", "\u201c", "\u201d", "\uff1f", "\uff01", "\uff08", "\uff09", "\uff1a", "\u2014\u2014", "\u3001"};
    static final String[] DBC = new String[]{",", ".", ";", "\"", "\"", "?", "!", "(", ")", ":", "_", ","};
    public static final int MAX_VARCHAR_PREPARE_LENGTH = 1000;

    public static String replaceBatch(String str, String ... arg) {
        if (arg == null) {
            return str;
        }
        for (int i = 0; i < arg.length; i += 2) {
            str = StringKit.replaceStr(str, arg[i], arg[i + 1]);
        }
        return str;
    }

    public static boolean eqOrNull(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s1.equals(s2);
    }

    public static String trim(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).length() == 0) {
            return null;
        }
        return str;
    }

    public static String replaceStr(String str, String oldStr, String newStr) {
        int pos1 = 0;
        int pos2 = 0;
        StringBuffer retu = new StringBuffer();
        if (str != null && str.length() > 0) {
            pos2 = str.indexOf(oldStr, pos1);
            while (pos2 != -1) {
                retu.append(str.substring(pos1, pos2) + newStr);
                pos1 = pos2 + oldStr.length();
                pos2 = str.indexOf(oldStr, pos1);
            }
            retu.append(str.substring(pos1));
        }
        return retu.toString();
    }

    public static String cap(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(Character.toUpperCase(str.charAt(0)));
        sb.append(str.substring(1).toLowerCase());
        return sb.toString();
    }

    public static boolean isWord(String str) {
        if (str == null) {
            return false;
        }
        char[] ch = str.toCharArray();
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isLetterOrDigit(ch[i]) || ch[i] == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean isNumAllowNig(String str) {
        if (str.startsWith("-")) {
            return StringKit.isNum(str.substring(1));
        }
        return StringKit.isNum(str);
    }

    public static boolean isNum(String str) {
        if (str == null || str.length() <= 0) {
            return false;
        }
        char[] ch = str.toCharArray();
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(ch[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumEx(String str) {
        if (str == null || str.length() <= 0) {
            return false;
        }
        char[] ch = str.toCharArray();
        int index = 0;
        if (ch[0] == '-') {
            index = 1;
        }
        int comcount = 0;
        for (int i = index; i < str.length(); ++i) {
            if (Character.isDigit(ch[i])) continue;
            if (ch[i] != '.') {
                return false;
            }
            if (i == 0 || i == str.length() - 1) {
                return false;
            }
            if (++comcount <= 1) continue;
            return false;
        }
        return true;
    }

    public static String replaceStrEq(String sReplace, String sOld, String sNew) {
        if (sReplace == null || sOld == null || sNew == null) {
            return null;
        }
        int iLen = sReplace.length();
        int iLenOldStr = sOld.length();
        int iLenNewStr = sNew.length();
        if (iLen <= 0 || iLenOldStr <= 0 || iLenNewStr <= 0) {
            return sReplace;
        }
        if (iLenOldStr != iLenNewStr) {
            return sReplace;
        }
        int[] iIndex = new int[iLen];
        iIndex[0] = sReplace.indexOf(sOld, 0);
        if (iIndex[0] == -1) {
            return sReplace;
        }
        int iIndexNum = 1;
        while (true) {
            iIndex[iIndexNum] = sReplace.indexOf(sOld, iIndex[iIndexNum - 1] + 1);
            if (iIndex[iIndexNum] == -1) break;
            ++iIndexNum;
        }
        char[] caReplace = sReplace.toCharArray();
        char[] caNewStr = sNew.toCharArray();
        for (int i = 0; i < iIndexNum; ++i) {
            for (int j = 0; j < iLenOldStr; ++j) {
                caReplace[j + iIndex[i]] = caNewStr[j];
            }
        }
        return new String(caReplace);
    }

    public static String replaceStrEx(String sReplace, String sOld, String sNew) {
        if (sReplace == null || sOld == null || sNew == null) {
            return null;
        }
        int iLen = sReplace.length();
        int iLenOldStr = sOld.length();
        int iLenNewStr = sNew.length();
        if (iLen <= 0 || iLenOldStr <= 0 || iLenNewStr < 0) {
            return sReplace;
        }
        int[] iIndex = new int[iLen];
        iIndex[0] = sReplace.indexOf(sOld, 0);
        if (iIndex[0] == -1) {
            return sReplace;
        }
        int iIndexNum = 1;
        while (true) {
            iIndex[iIndexNum] = sReplace.indexOf(sOld, iIndex[iIndexNum - 1] + 1);
            if (iIndex[iIndexNum] == -1) break;
            ++iIndexNum;
        }
        ArrayList<String> vStore = new ArrayList<String>();
        String sub = sReplace.substring(0, iIndex[0]);
        if (sub != null) {
            vStore.add(sub);
        }
        int i = 1;
        for (i = 1; i < iIndexNum; ++i) {
            vStore.add(sReplace.substring(iIndex[i - 1] + iLenOldStr, iIndex[i]));
        }
        vStore.add(sReplace.substring(iIndex[i - 1] + iLenOldStr, iLen));
        StringBuffer sbReplaced = new StringBuffer("");
        for (i = 0; i < iIndexNum; ++i) {
            sbReplaced.append(vStore.get(i) + sNew);
        }
        sbReplaced.append(vStore.get(i));
        return sbReplaced.toString();
    }

    public static String[] splitStr(String sStr, String sSplitter) {
        if (sStr == null || sStr.length() <= 0 || sSplitter == null || sSplitter.length() <= 0) {
            return null;
        }
        String[] saRet = null;
        int[] iIndex = new int[sStr.length()];
        iIndex[0] = sStr.indexOf(sSplitter, 0);
        if (iIndex[0] == -1) {
            saRet = new String[]{sStr};
            return saRet;
        }
        int iIndexNum = 1;
        while (true) {
            iIndex[iIndexNum] = sStr.indexOf(sSplitter, iIndex[iIndexNum - 1] + 1);
            if (iIndex[iIndexNum] == -1) break;
            ++iIndexNum;
        }
        Vector<String> vStore = new Vector<String>();
        int iLen = sSplitter.length();
        int i = 0;
        String sub = null;
        for (i = 0; i < iIndexNum + 1; ++i) {
            sub = i == 0 ? sStr.substring(0, iIndex[0]) : (i == iIndexNum ? sStr.substring(iIndex[i - 1] + iLen, sStr.length()) : sStr.substring(iIndex[i - 1] + iLen, iIndex[i]));
            if (sub == null || sub.length() <= 0) continue;
            vStore.add(sub);
        }
        if (vStore.size() <= 0) {
            return null;
        }
        saRet = new String[vStore.size()];
        Enumeration e = vStore.elements();
        i = 0;
        while (e.hasMoreElements()) {
            saRet[i] = (String)e.nextElement();
            ++i;
        }
        return saRet;
    }

    public static String contactStr(String[] saStr, String sContacter) {
        if (saStr == null || saStr.length <= 0 || sContacter == null || sContacter.length() <= 0) {
            return null;
        }
        StringBuffer sRet = new StringBuffer("");
        for (int i = 0; i < saStr.length; ++i) {
            if (i == saStr.length - 1) {
                sRet.append(saStr[i]);
                continue;
            }
            sRet.append(saStr[i] + sContacter);
        }
        return sRet.toString();
    }

    public static String contactStr(int[] saStr, String sContacter) {
        if (saStr == null || saStr.length <= 0 || sContacter == null || sContacter.length() <= 0) {
            return null;
        }
        StringBuffer sRet = new StringBuffer("");
        for (int i = 0; i < saStr.length; ++i) {
            if (i == saStr.length - 1) {
                sRet.append(new Integer(saStr[i]));
                continue;
            }
            sRet.append(new Integer(saStr[i]) + sContacter);
        }
        return sRet.toString();
    }

    public static String[] sortByLength(String[] saSource, boolean bAsc) {
        if (saSource == null || saSource.length <= 0) {
            return null;
        }
        int iLength = saSource.length;
        String[] saDest = new String[iLength];
        for (int i = 0; i < iLength; ++i) {
            saDest[i] = saSource[i];
        }
        String sTemp = "";
        int j = 0;
        int k = 0;
        for (j = 0; j < iLength; ++j) {
            for (k = 0; k < iLength - j - 1; ++k) {
                if (saDest[k].length() > saDest[k + 1].length() && bAsc) {
                    sTemp = saDest[k];
                    saDest[k] = saDest[k + 1];
                    saDest[k + 1] = sTemp;
                    continue;
                }
                if (saDest[k].length() >= saDest[k + 1].length() || bAsc) continue;
                sTemp = saDest[k];
                saDest[k] = saDest[k + 1];
                saDest[k + 1] = sTemp;
            }
        }
        return saDest;
    }

    public static String compactStr(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() <= 0) {
            return "";
        }
        String sDes = new String(str);
        int iBlanksAtStart = 0;
        int iLen = str.length();
        while (sDes.charAt(iBlanksAtStart) == ' ' && ++iBlanksAtStart < iLen) {
        }
        String[] saDes = StringKit.splitStr(sDes.trim(), " ");
        if (saDes == null) {
            return null;
        }
        int i = 0;
        for (i = 0; i < saDes.length; ++i) {
            saDes[i] = saDes[i].trim();
        }
        sDes = StringKit.contactStr(saDes, " ");
        StringBuffer sBlank = new StringBuffer("");
        for (i = 0; i < iBlanksAtStart; ++i) {
            sBlank.append(" ");
        }
        return sBlank.toString() + sDes;
    }

    public static String symbolSBCToDBC(String sSource) {
        if (sSource == null || sSource.length() <= 0) {
            return sSource;
        }
        int iLen = SBC.length < DBC.length ? SBC.length : DBC.length;
        for (int i = 0; i < iLen; ++i) {
            sSource = StringKit.replaceStrEx(sSource, SBC[i], DBC[i]);
        }
        return sSource;
    }

    public static String symbolDBCToSBC(String sSource) {
        if (sSource == null || sSource.length() <= 0) {
            return sSource;
        }
        int iLen = SBC.length < DBC.length ? SBC.length : DBC.length;
        for (int i = 0; i < iLen; ++i) {
            sSource = StringKit.replaceStrEx(sSource, DBC[i], SBC[i]);
        }
        return sSource;
    }

    public static boolean isEmailUrl(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        return str.indexOf(64) > 0 && str.indexOf(64) == str.lastIndexOf(64) && str.indexOf(46) > 0 && str.lastIndexOf(46) > str.indexOf(64);
    }

    public static boolean isEmailAddress(String str) {
        if (str == null || str.length() <= 0) {
            return false;
        }
        boolean iCommonCount = false;
        int iAltCount = 0;
        char[] chEmail = str.trim().toCharArray();
        for (int i = 0; i < chEmail.length; ++i) {
            if (chEmail[i] == ' ') {
                return false;
            }
            if (!(chEmail[i] == '.' ? i == 0 || i == chEmail.length - 1 : chEmail[i] == '@' && (++iAltCount > 1 || i == 0 || i == chEmail.length - 1))) continue;
            return false;
        }
        return str.indexOf(46) >= str.indexOf(64);
    }

    public static String formatDate(Date date, String newFormat) {
        if (date == null || newFormat == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(newFormat);
        return formatter.format(date);
    }

    public static final Date string2Date(String dateString, String format) {
        if (null == dateString || dateString.equals("")) {
            return null;
        }
        if (null == format || format.equals("")) {
            format = "yyyy-MM-dd";
        }
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        try {
            date = formatter.parse(dateString);
        }
        catch (Exception ex) {
            date = null;
        }
        return date;
    }

    public static String cEmpty(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static String cNull(String s) {
        if (s == null) {
            return null;
        }
        if (s.trim().length() == 0) {
            return null;
        }
        return s;
    }

    public static String nullString(String s) {
        if (s == null) {
            return "Null";
        }
        if (s.trim().length() == 0) {
            return "Null";
        }
        return "'" + s.trim() + "'";
    }

    public static String filterString(String s, String t) {
        int i;
        String a = s;
        int j = t.length();
        while ((i = a.indexOf(t)) != -1) {
            a = a.substring(0, i - 1) + a.substring(i + j);
        }
        return a;
    }

    public static int getTotalBytes(String srcString) {
        if (srcString == null) {
            return 0;
        }
        int result = 0;
        byte[] bytes = srcString.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == 0) continue;
            ++result;
        }
        return result;
    }

    public static boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().length() == 0;
    }

    public static boolean isStrSuite(String ssub, String sparent) {
        ssub = ssub.trim();
        sparent = sparent.trim();
        String[] subarr = StringKit.splitStr(ssub, " ");
        String[] pararr = StringKit.splitStr(sparent, " ");
        return StringKit.isStringArraySuite(subarr, pararr);
    }

    public static boolean isStringArraySuite(String[] subarr, String[] pararr) {
        if (subarr.length > pararr.length) {
            return false;
        }
        for (int i = 0; i < subarr.length; ++i) {
            if (subarr[i].equals("*") || pararr[i].equals("*") || subarr[i].equals(pararr[i])) continue;
            return false;
        }
        return true;
    }

    public static String arrToString(Object arr) {
        String ret = "\nlen=" + Array.getLength(arr);
        for (int i = 0; i < Array.getLength(arr); ++i) {
            ret = ret + "\nitem[" + i + "]=" + Array.get(arr, i);
        }
        return ret;
    }

    public static String mapToString(Map map) {
        String ret = "\nlen=" + map.keySet().size();
        for (Object key : map.keySet()) {
            ret = ret + "\nkey[" + key + "]" + "  value=" + map.get(map.get(key));
        }
        return ret;
    }

    public static boolean isNotNullAndBlank(String str) {
        return !StringKit.isNullOrBlank(str);
    }

    public static boolean isNullOrBlank(String str) {
        return StringKit.isNull(str) || str.equals("") || str.equals("null");
    }

    public static boolean isNull(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isNotNull(String str) {
        return str != null && str.trim().length() != 0;
    }

    public static String ifNullToBlank(String str) {
        if (StringKit.isNotNull(str) && !str.trim().equals("null")) {
            return str.trim();
        }
        return "";
    }

    public static String ifNullToBlank(Object obj) {
        String ret = "";
        String s = String.valueOf(obj);
        ret = s == null || "".equals(s) || "null".equals(s) || "NULL".equals(s) ? "" : s;
        return ret;
    }

    public static final String escapeXML(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] sArray = string.toCharArray();
        StringBuffer buf = new StringBuffer(sArray.length);
        for (int i = 0; i < sArray.length; ++i) {
            char ch = sArray[i];
            if (ch == '<') {
                buf.append("&lt;");
                continue;
            }
            if (ch == '&') {
                buf.append("&amp;");
                continue;
            }
            if (ch == '\"') {
                buf.append("&quot;");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String[] splitStrWithBlank(String str, String delim) {
        if (str == null) {
            return null;
        }
        if (str.trim().equals("")) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int index = 0;
        while ((index = str.indexOf(delim)) >= 0) {
            list.add(str.substring(0, index));
            str = str.substring(index + 1, str.length());
        }
        list.add(str);
        String[] strs = new String[list.size()];
        list.toArray(strs);
        return strs;
    }

    public static char getCharAtPosDefaultZero(String s, int pos) {
        if (s == null) {
            return '0';
        }
        if (s.length() <= pos) {
            return '0';
        }
        return s.charAt(pos);
    }

    public static String setCharAtPosAppendZero(String s, int pos, char c) {
        if (s == null) {
            s = "";
        }
        while (pos > s.length() - 1) {
            s = s + '0';
        }
        String preString = pos == 0 ? "" : s.substring(0, pos);
        String afterString = pos == s.length() - 1 ? "" : s.substring(pos + 1);
        return preString + c + afterString;
    }

    public static String changeStreamToString(InputStream stream, String encode) throws IOException {
        int len;
        byte[] b100k = new byte[200000];
        int pos = 0;
        while ((len = stream.read(b100k, pos, b100k.length - pos)) > 0) {
            pos += len;
        }
        if (pos >= b100k.length - 1) {
            throw new IOException("ERROR:The stream size is more than " + b100k.length + " bytes");
        }
        return new String(b100k, 0, pos, encode);
    }

    public static String fillBlank(String s, int n, boolean isLeft) {
        if (s.length() >= n) {
            return s;
        }
        for (int i = s.length(); i < n; ++i) {
            s = isLeft ? " " + s : s + " ";
        }
        return s;
    }

    public static String replaceBlanks(String s) {
        Pattern ptn = Pattern.compile("\\t|\r|\n");
        Matcher mt = ptn.matcher(s);
        return mt.replaceAll("");
    }

    public static String replaceScriptKeyword(String src) {
        Pattern ptn = Pattern.compile("<script>");
        Matcher mt = ptn.matcher(src);
        src = mt.replaceAll("<scriptValue>");
        ptn = Pattern.compile("</script>");
        mt = ptn.matcher(src);
        return mt.replaceAll("</scriptValue>");
    }

    public static int compareVersion(String version1, String version2) {
        StringTokenizer st1 = new StringTokenizer(version1, ".");
        StringTokenizer st2 = new StringTokenizer(version2, ".");
        ArrayList<String> al1 = new ArrayList<String>();
        ArrayList<String> al2 = new ArrayList<String>();
        while (st1.hasMoreTokens()) {
            al1.add(st1.nextToken());
        }
        while (st2.hasMoreTokens()) {
            al2.add(st2.nextToken());
        }
        int size1 = al1.size();
        int size2 = al2.size();
        for (int i = 0; i < size1 && i < size2; ++i) {
            int v2;
            int v1 = Integer.parseInt((String)al1.get(i));
            if (v1 > (v2 = Integer.parseInt((String)al2.get(i)))) {
                return 1;
            }
            if (v1 >= v2) continue;
            return -1;
        }
        if (size1 > size2) {
            return 1;
        }
        if (size1 < size2) {
            return -1;
        }
        return 0;
    }

    public static int nativeLength(String s) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        int length = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) >= '\u0100') {
                length += 3;
                continue;
            }
            ++length;
        }
        return length;
    }

    public static String varcharSQLString(List retList, String value) {
        if (value != null && StringKit.nativeLength(value) > 1000) {
            String sql = "?";
            StringBuffer buff = new StringBuffer("");
            int len = 0;
            int sLen = value.length();
            for (int i = 0; i < sLen; ++i) {
                char c = value.charAt(i);
                if (c >= '\u0100') {
                    if (len + 3 > 1000) {
                        retList.add(buff.toString());
                        sql = sql.concat(" || ?");
                        buff = new StringBuffer(String.valueOf(c));
                        len = 3;
                        continue;
                    }
                    len += 3;
                } else {
                    ++len;
                }
                buff.append(c);
                if (len != 1000) continue;
                retList.add(buff.toString());
                if (i < sLen - 1) {
                    sql = sql.concat(" || ?");
                }
                buff = new StringBuffer("");
                len = 0;
            }
            if (len > 0) {
                retList.add(buff.toString());
            }
            return sql;
        }
        retList.add(value);
        return null;
    }

    public static int compare(String s1, String s2) {
        for (int i = 0; i < s1.length() && i < s2.length(); ++i) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 > (c2 = s2.charAt(i))) {
                return 1;
            }
            if (c1 >= c2) continue;
            return -1;
        }
        if (s1.length() > s2.length()) {
            return 1;
        }
        if (s1.length() < s2.length()) {
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) {
        System.out.println(StringKit.compare("ab", "ab"));
        System.out.println(StringKit.compare("", ""));
        System.out.println(StringKit.compare("ab", "ac"));
        System.out.println(StringKit.compare("ac", "ab"));
        System.out.println(StringKit.compare("ab", "abc"));
    }

    public static String null2Empty(String hcond) {
        if (hcond == null) {
            return "";
        }
        return hcond;
    }

    public static String repaceFirst(String s, String toReplace, String replacement) {
        int pos = s.indexOf(toReplace);
        if (pos < 0) {
            return s;
        }
        return s.substring(0, pos) + replacement + s.substring(pos + toReplace.length());
    }

    public static String repaceFirstIgnoreCase(String s, String toReplace, String replacement) {
        int pos = s.toUpperCase().indexOf(toReplace.toUpperCase());
        if (pos < 0) {
            return s;
        }
        return s.substring(0, pos) + replacement + s.substring(pos + toReplace.length());
    }

    public static String[] splitStrAndTrim(String str, String spliter) {
        String[] result = StringKit.splitStr(str, spliter);
        if (result == null) {
            return null;
        }
        String[] newArr = new String[result.length];
        for (int i = 0; i < result.length; ++i) {
            newArr[i] = result[i].trim();
        }
        return newArr;
    }

    public static String list2String(List<Object> bindings) {
        StringBuffer sb = new StringBuffer();
        for (Object b : bindings) {
            sb.append(b).append(" , ");
        }
        return sb.toString();
    }
}

