/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.common.kits;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jplugin.common.kits.PritiveKits;
import net.jplugin.common.kits.TestBean;

public class JsonKit {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static Object json2Object4Type(String json, Type type) {
        Object object = null;
        try {
            if (json != null && json.length() > 0) {
                if (type instanceof Class) {
                    object = JsonKit.json2Object(json, (Class)type);
                } else {
                    JavaType javaType = mapper.getTypeFactory().constructType(type);
                    object = mapper.readValue(json, javaType);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return object;
    }

    public static Object json2Object4TypeEx(String val, Type type) {
        if (val == null || val.equals("")) {
            return null;
        }
        Class clz = null;
        PritiveKits.Transformer trans = null;
        if (type instanceof Class) {
            clz = (Class)type;
            trans = PritiveKits.getTransformer(clz);
        }
        if (trans != null) {
            return trans.fromString(clz, val);
        }
        return JsonKit.json2Object4Type(val, type);
    }

    public static String object2Json(Object object) {
        StringWriter writer = new StringWriter();
        try {
            if (object != null) {
                mapper.writeValue((Writer)writer, object);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    public static <T> T json2Object(String json, Class<T> klass) {
        Object object = null;
        try {
            if (json != null && json.length() > 0) {
                object = mapper.readValue(json, klass);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)object;
    }

    public static Map json2Map(String json) {
        Map m = null;
        try {
            if (json != null && json.length() > 0) {
                m = (Map)mapper.readValue(json, Map.class);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return m;
    }

    @Deprecated
    public static List<Map> json2ListMap(String json) {
        return JsonKit.json2List(json);
    }

    public static List json2List(String json) {
        List m = null;
        try {
            if (json != null && json.length() > 0) {
                m = (List)mapper.readValue(json, List.class);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return m;
    }

    @Deprecated
    public static <T> List<T> json2ListBean(String json, Class<T> beanClass) {
        List m = null;
        try {
            if (json != null && json.length() > 0) {
                JavaType javaType = JsonKit.getCollectionType(ArrayList.class, beanClass);
                m = (List)mapper.readValue(json, javaType);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return m;
    }

    public static <K, V> Map json2MapBean(String json, Class<K> keyClass, Class<V> beanClass) {
        Map m = null;
        try {
            if (json != null && json.length() > 0) {
                JavaType javaType = JsonKit.getCollectionType(HashMap.class, keyClass, beanClass);
                m = (Map)mapper.readValue(json, javaType);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return m;
    }

    public static void main1(String[] args) {
        TestBean o = new TestBean();
        TestBean o2 = new TestBean();
        TestBean[] arr = new TestBean[]{o, o2};
        System.out.println(JsonKit.object2Json(arr));
        String json = JsonKit.object2Json(arr);
        TestBean[] ret = JsonKit.json2Object(json, TestBean[].class);
        System.out.println(JsonKit.object2Json(ret));
        List list = JsonKit.json2Object(json, List.class);
        System.out.println(JsonKit.object2Json(list));
    }

    public static void main(String[] args) {
        TestBean[] arr = new TestBean[]{new TestBean(), new TestBean()};
        String json = JsonKit.object2Json(arr);
        System.out.println(json);
        Object obj = JsonKit.json2ObjectEx(json, arr.getClass());
        System.out.println(JsonKit.object2JsonEx(obj));
    }

    public static void main2(String[] args) throws Exception {
        int[] arr = new int[]{1, 2, 3};
        ArrayList<Object> al = new ArrayList<Object>();
        al.add(1);
        al.add(2);
        al.add("3");
        System.out.println("int arr = " + JsonKit.object2Json(arr));
        System.out.println("list = " + JsonKit.object2Json(arr));
        System.out.println("str = " + JsonKit.object2Json("111"));
        System.out.println("int = " + JsonKit.object2Json(111));
        System.out.println("date = " + JsonKit.object2Json(new Date()));
        String json = "[{\"name\":\"aaa\",\"age\":\"15\"}, {\"name\":\"bbb\",\"age\":\"25\"}]";
        List<TestBean> lst = JsonKit.json2ListBean(json, TestBean.class);
        System.out.println(lst);
        System.out.println(lst.get(0).getName());
        json = "{\"t1\":{\"name\":\"aaa\",\"age\":\"15\"}, \"t2\":{\"name\":\"bbb\",\"age\":\"25\"}}";
        Map mst = JsonKit.json2MapBean(json, String.class, TestBean.class);
        System.out.println(mst);
        System.out.println(((TestBean)mst.get("t1")).getName());
    }

    private static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public static <T> Object json2ObjectEx(String val, Class<T> clz) {
        if (val == null || val.equals("")) {
            return null;
        }
        PritiveKits.Transformer trans = PritiveKits.getTransformer(clz);
        if (trans != null) {
            return trans.fromString(clz, val);
        }
        return JsonKit.json2Object(val, clz);
    }

    public static String object2JsonEx(Object obj) {
        if (obj == null) {
            return "";
        }
        PritiveKits.Transformer trans = PritiveKits.getTransformer(obj.getClass());
        if (trans != null) {
            return trans.convertToString(obj);
        }
        return JsonKit.object2Json(obj);
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

