/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.log.impl;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import net.jplugin.common.kits.FileKit;
import net.jplugin.common.kits.PropertiesKit;
import net.jplugin.core.config.api.ConfigFactory;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.kernel.kits.KernelKit;
import net.jplugin.core.log.api.ILogService;
import net.jplugin.core.log.api.Logger;
import net.jplugin.core.log.impl.Logger4Log4j;
import net.jplugin.core.log.impl.LoggerListCacher;
import org.apache.log4j.Appender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;

public class LogServiceImpl
implements ILogService {
    private boolean inited = false;
    Hashtable<String, Logger> calledNames = new Hashtable();

    public void initFromConfig() {
        Map<String, String> configs = ConfigFactory.getStringConfigInGroup("log4j");
        if (configs != null && !configs.isEmpty()) {
            PluginEnvirement.getInstance().getStartLogger().log("Using global logger config");
            Properties p = new Properties();
            for (Map.Entry<String, String> e : configs.entrySet()) {
                p.setProperty(e.getKey(), e.getValue());
            }
            this.initFromProperties(p);
        } else {
            PluginEnvirement.getInstance().getStartLogger().log("Using local logger config");
            this.initWithLocalConfig();
        }
        this.inited = true;
        LoggerListCacher.createLog4jLoggers();
    }

    private void initWithLocalConfig() {
        String path = KernelKit.getConfigFilePath("log4j.properties");
        Properties prop = null;
        try {
            if (FileKit.existsFile(path)) {
                prop = PropertiesKit.loadProperties(path);
            } else {
                PluginEnvirement.getInstance().getStartLogger().log("Using classpath logger config");
                prop = PropertiesKit.loadFromClassPath(this.getClass(), "log4j.properties");
            }
        }
        catch (Exception e) {
            PluginEnvirement.INSTANCE.getStartLogger().log("Warnning : Log4j.properties not found at:" + path);
            return;
        }
        this.initFromProperties(prop);
    }

    private void initFromProperties(Properties prop) {
        PropertiesKit.replaceVar(prop, "work-dir", PluginEnvirement.getInstance().getWorkDir());
        PropertyConfigurator.configure((Properties)prop);
    }

    @Override
    public Logger getLogger(String name) {
        if (!this.inited) {
            return new Logger4Log4j(name);
        }
        return new Logger4Log4j(org.apache.log4j.Logger.getLogger((String)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Logger getSpecicalLogger(String filename) {
        if (!this.inited) {
            throw new RuntimeException("Can't call getSpecicalLogger before inited!");
        }
        Logger ret = this.calledNames.get(filename);
        if (ret == null) {
            LogServiceImpl logServiceImpl = this;
            synchronized (logServiceImpl) {
                ret = this.calledNames.get(filename);
                if (ret == null) {
                    ret = this.createLogger(filename);
                    this.calledNames.put(filename, ret);
                }
            }
        }
        return ret;
    }

    private Logger createLoggerOld(String filename) {
        DailyRollingFileAppender append;
        org.apache.log4j.Logger theSpecifialLog = org.apache.log4j.Logger.getLogger((String)("$" + filename));
        theSpecifialLog.setAdditivity(false);
        theSpecifialLog.setLevel(Level.DEBUG);
        try {
            append = new DailyRollingFileAppender((Layout)new PatternLayout(), PluginEnvirement.getInstance().getWorkDir() + "/logs/" + filename, "'.'yyyy-MM-dd'.log'");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        theSpecifialLog.addAppender((Appender)append);
        return new Logger4Log4j(theSpecifialLog);
    }

    private Logger createLogger(String filename) {
        RollingFileAppender append;
        org.apache.log4j.Logger theSpecifialLog = org.apache.log4j.Logger.getLogger((String)("$" + filename));
        theSpecifialLog.setAdditivity(false);
        theSpecifialLog.setLevel(Level.DEBUG);
        try {
            PatternLayout layout = new PatternLayout();
            layout.setConversionPattern("%d %m %n");
            append = new RollingFileAppender((Layout)layout, PluginEnvirement.getInstance().getWorkDir() + "/logs/" + filename);
            append.setMaxBackupIndex(25);
            append.setMaxFileSize("20MB");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        theSpecifialLog.addAppender((Appender)append);
        return new Logger4Log4j(theSpecifialLog);
    }
}

