/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.kernel.impl_incept;

import java.util.ArrayList;
import java.util.List;
import net.jplugin.common.kits.AssertKit;
import net.jplugin.core.kernel.api.AbstractExtensionInterceptor;
import net.jplugin.core.kernel.api.AbstractPlugin;
import net.jplugin.core.kernel.api.Extension;
import net.jplugin.core.kernel.api.ExtensionPoint;
import net.jplugin.core.kernel.api.IExtensionFactory;
import net.jplugin.core.kernel.api.IExtensionFactoryInterceptAble;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.kernel.impl_incept.ExtensionInterceptorFactory;

public class ExtensionInterceptorManager {
    private static List<Extension> list = new ArrayList<Extension>();
    private static List<Extension> extensionsNeedIntercept = new ArrayList<Extension>();

    public static void setInterceptorsToFactories() {
        ExtensionPoint point = PluginEnvirement.getInstance().getExtensionPoint("EP_EXTENSION_INTERCEPTOR");
        List<Extension> sortedList = point.__debugGetExtensions();
        AssertKit.assertEqual(sortedList.size(), list.size());
        list = sortedList;
        for (Extension ext : extensionsNeedIntercept) {
            List interceptorList = ExtensionInterceptorManager.getInterceptorList(ext);
            ((IExtensionFactoryInterceptAble)((Object)ext.getFactory())).setInterceptors(interceptorList);
        }
    }

    public static void setNeedIntercept() {
        List<Extension> exts;
        List<AbstractPlugin> plugins = PluginEnvirement.getInstance().getPluginRegistry().getPluginList();
        for (AbstractPlugin plugin : plugins) {
            exts = plugin.getExtensions();
            for (Extension ext : exts) {
                if (!ext.getExtensionPointName().equals("EP_EXTENSION_INTERCEPTOR")) continue;
                list.add(ext);
            }
        }
        for (AbstractPlugin plugin : plugins) {
            exts = plugin.getExtensions();
            for (Extension ext : exts) {
                if (!ExtensionInterceptorManager.checkNeedIntercept(ext)) continue;
                if (ext.getFactory() instanceof IExtensionFactoryInterceptAble) {
                    IExtensionFactoryInterceptAble efia = (IExtensionFactoryInterceptAble)((Object)ext.getFactory());
                    extensionsNeedIntercept.add(ext);
                    efia.setNeedIntercept();
                    continue;
                }
                PluginEnvirement.getInstance().getStartLogger().log("Extension " + ext.getClazz().getName() + " not support intercept.");
            }
        }
    }

    private static List getInterceptorList(Extension ext) {
        ArrayList<AbstractExtensionInterceptor> result = new ArrayList<AbstractExtensionInterceptor>(list.size());
        for (Extension interceptorExtension : list) {
            IExtensionFactory fac = interceptorExtension.getFactory();
            if (!((ExtensionInterceptorFactory)fac).matchExtension(ext)) continue;
            result.add((AbstractExtensionInterceptor)interceptorExtension.getObject());
        }
        AssertKit.assertTrue(result.size() > 0);
        return result;
    }

    private static boolean checkNeedIntercept(Extension ext) {
        for (Extension interceptorExtension : list) {
            IExtensionFactory fac = interceptorExtension.getFactory();
            if (!((ExtensionInterceptorFactory)fac).matchExtension(ext)) continue;
            return true;
        }
        return false;
    }
}

