/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.kernel.impl;

import net.jplugin.common.kits.CalenderKit;
import net.jplugin.common.kits.FileKit;
import net.jplugin.core.kernel.api.IStartLogger;
import net.jplugin.core.kernel.api.PluginEnvirement;

public class StartUpLoggerImpl
implements IStartLogger {
    private static final long LIMIT_SIZE = 0x100000L;

    @Override
    public synchronized void log(Object o) {
        String msg = o == null ? "null" : o.toString();
        FileKit.appendFile(StartUpLoggerImpl.getFile(), this.header() + msg + "\r\n");
        System.out.println(msg);
    }

    private String header() {
        return CalenderKit.getFormatedTimeString(System.currentTimeMillis(), " yyyy-MM-dd HH:mm:ss") + "  ";
    }

    @Override
    public synchronized void log(Object o, Throwable th) {
        String msg = o == null ? "null" : o.toString();
        FileKit.appendFile(StartUpLoggerImpl.getFile(), this.header() + msg + "\r\n");
        System.out.println(msg);
        FileKit.appendStackTrace(StartUpLoggerImpl.getFile(), th);
        th.printStackTrace();
    }

    @Override
    public synchronized void write(Object s) {
        FileKit.appendFile(StartUpLoggerImpl.getFile(), s.toString());
        System.out.print(s);
    }

    static String getFile() {
        String logger = PluginEnvirement.getInstance().getLogDir() + "/jplugin-start.log";
        if (FileKit.existsAndIsFile(logger) && FileKit.getFileSize(logger) > 0x100000L) {
            StartUpLoggerImpl.renameAndDel(logger);
        }
        return logger;
    }

    private static void renameAndDel(String logger) {
        int max = 5;
        StartUpLoggerImpl.removeFile(logger, max);
        for (int i = max; i >= 0; --i) {
            StartUpLoggerImpl.renameFile(logger, i);
        }
        FileKit.createEmptyFile(logger);
    }

    private static void renameFile(String logger, int i) {
        String from = i == 0 ? logger : logger + "." + i + ".txt";
        String to = logger + "." + (i + 1) + ".txt";
        FileKit.renameFile(from, to);
    }

    private static void removeFile(String logger, int i) {
        String name = logger + "." + i + ".txt";
        if (FileKit.existsFile(name)) {
            FileKit.removeFile(name);
        }
    }
}

