/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.kernel.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.jplugin.common.kits.Comparor;
import net.jplugin.common.kits.SortUtil;
import net.jplugin.core.kernel.api.PluginAnnotation;

public class PluginPrepareHelper {
    private static Class needPrepare(Class c) {
        try {
            Class clazz = c;
            Method method = clazz.getMethod("prepare", new Class[0]);
            if ((method.getModifiers() & 8) > 0) {
                return clazz;
            }
            System.out.println("Important Warnning:plugin " + c.getName() + " not prepared,method not static");
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static void classPrepare(int index, Class clazz) {
        try {
            System.out.println("PreparePlugin : [" + index + "] " + clazz.getName());
            Method method = clazz.getMethod("prepare", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getMessage(), e.getTargetException());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void preparePlugins(List<Class> pluginToLoad) {
        ArrayList<Class> classNeedPrepare = new ArrayList<Class>();
        for (Class obj : pluginToLoad) {
            Class c = PluginPrepareHelper.needPrepare(obj);
            if (c == null) continue;
            classNeedPrepare.add(c);
        }
        SortUtil.sort(classNeedPrepare, new Comparor(){

            @Override
            public boolean isGreaterThen(Object o1, Object o2) {
                Class c1 = (Class)o1;
                Class c2 = (Class)o2;
                PluginAnnotation a1 = c1.getAnnotation(PluginAnnotation.class);
                PluginAnnotation a2 = c2.getAnnotation(PluginAnnotation.class);
                int s1 = a1 == null ? 0 : a1.prepareSeq();
                int s2 = a2 == null ? 0 : a2.prepareSeq();
                return s1 > s2;
            }
        });
        for (int i = 0; i < classNeedPrepare.size(); ++i) {
            PluginPrepareHelper.classPrepare(i, (Class)classNeedPrepare.get(i));
        }
    }
}

