/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.kernel.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.jplugin.common.kits.AssertKit;
import net.jplugin.core.kernel.api.AbstractPlugin;
import net.jplugin.core.kernel.api.Extension;
import net.jplugin.core.kernel.api.ExtensionPoint;
import net.jplugin.core.kernel.api.PluginEnvirement;

public class PluginRegistryHelper {
    public static void reorderSamePriorityPlugins(List<AbstractPlugin> list) {
        int pos = 0;
        while (pos < list.size() - 1) {
            if (list.get(pos).getPrivority() == list.get(pos + 1).getPrivority()) {
                List<AbstractPlugin> temp = PluginRegistryHelper.getSimplePriorityPlugins(list, pos);
                PluginEnvirement.getInstance().getStartLogger().log("Found simple priority plugins :" + PluginRegistryHelper.getNames(temp));
                PluginRegistryHelper.reOrder(temp);
                PluginEnvirement.getInstance().getStartLogger().log("After reorder :" + PluginRegistryHelper.getNames(temp));
                PluginRegistryHelper.putBack(list, temp, pos);
                pos += temp.size();
                continue;
            }
            ++pos;
        }
    }

    private static String getNames(List<AbstractPlugin> temp) {
        StringBuffer sb = new StringBuffer();
        for (AbstractPlugin item : temp) {
            sb.append(item.getName()).append(" , ");
        }
        sb.append("]");
        return sb.toString();
    }

    private static void putBack(List<AbstractPlugin> allList, List<AbstractPlugin> temp, int startPos) {
        for (int i = 0; i < temp.size(); ++i) {
            allList.set(startPos + i, temp.get(i));
        }
    }

    private static void reOrder(List<AbstractPlugin> targetList) {
        List<ExtendRelation> extendRelations = PluginRegistryHelper.getExtendRelations(targetList);
        ArrayList<AbstractPlugin> tempSortList = new ArrayList<AbstractPlugin>(targetList.size());
        tempSortList.addAll(targetList);
        targetList.clear();
        while (!tempSortList.isEmpty()) {
            List<PluginScore> pluginScoreList = PluginRegistryHelper.getPluginScores(extendRelations, tempSortList);
            PluginScore maxPluginScore = null;
            for (PluginScore current : pluginScoreList) {
                if (maxPluginScore == null) {
                    maxPluginScore = current;
                    continue;
                }
                if (current.score <= maxPluginScore.score) continue;
                maxPluginScore = current;
            }
            targetList.add(maxPluginScore.plugin);
            tempSortList.remove(maxPluginScore.plugin);
            for (int i = extendRelations.size() - 1; i >= 0; --i) {
                ExtendRelation er = extendRelations.get(i);
                if (er.extend != maxPluginScore.plugin && er.extended != maxPluginScore.plugin) continue;
                extendRelations.remove(i);
            }
        }
    }

    private static List<PluginScore> getPluginScores(List<ExtendRelation> extendRelations, List<AbstractPlugin> tempSortList) {
        ArrayList<PluginScore> pluginScoreList = new ArrayList<PluginScore>(tempSortList.size());
        tempSortList.forEach(p -> pluginScoreList.add(PluginRegistryHelper.makePluginScore(p, extendRelations)));
        return pluginScoreList;
    }

    private static PluginScore makePluginScore(AbstractPlugin p, List<ExtendRelation> extendRelations) {
        int extendNum = 0;
        for (ExtendRelation er : extendRelations) {
            if (er.extend != p) continue;
            ++extendNum;
        }
        PluginScore ps = new PluginScore();
        ps.plugin = p;
        ps.score = extendNum * -1000000 + p.getExtensionPoints().size() * 1000 + p.getExtensions().size();
        return ps;
    }

    private static List<ExtendRelation> getExtendRelations(List<AbstractPlugin> list) {
        ArrayList<ExtendRelation> results = new ArrayList<ExtendRelation>();
        for (AbstractPlugin plugin : list) {
            List<Extension> exts = plugin.getExtensions();
            if (exts.size() <= 0) continue;
            HashSet pointToNameSet = new HashSet();
            exts.forEach(e -> pointToNameSet.add(e.getExtensionPointName()));
            block1: for (String pointToName : pointToNameSet) {
                for (AbstractPlugin p : list) {
                    if (p == plugin || !PluginRegistryHelper.checkExtend(pointToName, p)) continue;
                    ExtendRelation er = new ExtendRelation();
                    er.extend = plugin;
                    er.extended = p;
                    results.add(er);
                    continue block1;
                }
            }
        }
        return results;
    }

    private static boolean checkExtend(String pointToName, AbstractPlugin plugin) {
        for (ExtensionPoint point : plugin.getExtensionPoints()) {
            if (!point.getName().equals(pointToName)) continue;
            return true;
        }
        return false;
    }

    private static List<AbstractPlugin> getSimplePriorityPlugins(List<AbstractPlugin> allPluginList, int startPos) {
        ArrayList<AbstractPlugin> result = new ArrayList<AbstractPlugin>();
        result.add(allPluginList.get(startPos));
        int priority = allPluginList.get(startPos).getPrivority();
        for (int i = startPos + 1; i < allPluginList.size(); ++i) {
            if (priority != allPluginList.get(i).getPrivority()) continue;
            result.add(allPluginList.get(i));
        }
        AssertKit.assertTrue(result.size() >= 2);
        return result;
    }

    private static class ExtendRelation {
        AbstractPlugin extend;
        AbstractPlugin extended;

        private ExtendRelation() {
        }
    }

    private static class PluginScore {
        AbstractPlugin plugin;
        int score;

        private PluginScore() {
        }
    }
}

