/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.kernel.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.jplugin.common.kits.Comparor;
import net.jplugin.common.kits.SortUtil;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.kernel.api.AbstractPlugin;
import net.jplugin.core.kernel.api.Extension;
import net.jplugin.core.kernel.api.ExtensionPoint;
import net.jplugin.core.kernel.api.IPlugin;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.kernel.api.PluginError;
import net.jplugin.core.kernel.api.PluginRegistryHelper;
import net.jplugin.core.kernel.api.plugin_event.PluginEventListenerManager;
import net.jplugin.core.kernel.impl.PluginPrepareHelper;

public class PluginRegistry {
    private List<AbstractPlugin> pluginList = new Vector<AbstractPlugin>();
    private List<PluginError> errorList = new Vector<PluginError>();
    private Hashtable<String, ExtensionPoint> extensionPointMap = new Hashtable();
    private Map<String, AbstractPlugin> loadedPluginMap = new Hashtable<String, AbstractPlugin>();
    private List<Class> pluginClasses = new ArrayList<Class>();

    public String printContent(boolean reverse) {
        StringBuffer sb = new StringBuffer();
        if (reverse) {
            for (int i = this.pluginList.size() - 1; i >= 0; --i) {
                sb.append("\n\nPlugin[").append(i + 1).append("] : ");
                sb.append(this.pluginList.get(i).printContent());
            }
        } else {
            for (int i = 0; i < this.pluginList.size(); ++i) {
                sb.append("\n\nPlugin[").append(i + 1).append("] : ");
                sb.append(this.pluginList.get(i).printContent());
            }
        }
        return sb.toString();
    }

    public List<PluginError> getErrors() {
        return this.errorList;
    }

    public List<AbstractPlugin> getPluginList() {
        return Collections.unmodifiableList(this.pluginList);
    }

    public void addPluginClasses(Set<Object> pluginToLoad) {
        for (Object name : pluginToLoad) {
            try {
                this.pluginClasses.add(Class.forName((String)name));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("The plugin class not found:" + name);
            }
        }
    }

    public void afterPluginsContruct() {
        for (int i = 0; i < this.pluginList.size(); ++i) {
            AbstractPlugin p = this.pluginList.get(i);
            p.afterPluginsContruct();
        }
    }

    public void afterPluginLoad() {
        for (int i = 0; i < this.pluginList.size(); ++i) {
            AbstractPlugin p = this.pluginList.get(i);
            p.afterPluginsLoad();
        }
    }

    public void afterWire() {
        for (int i = 0; i < this.pluginList.size(); ++i) {
            AbstractPlugin p = this.pluginList.get(i);
            p.afterWire();
        }
    }

    public void sort() {
        this.checkSameName(this.errorList);
        SortUtil.sort(this.pluginList, new Comparor(){

            @Override
            public boolean isGreaterThen(Object o1, Object o2) {
                AbstractPlugin p1 = (AbstractPlugin)o1;
                AbstractPlugin p2 = (AbstractPlugin)o2;
                if (p1.getPrivority() > p2.getPrivority()) {
                    return true;
                }
                if (p1.getPrivority() < p2.getPrivority()) {
                    return false;
                }
                int nameCompResult = StringKit.compare(p1.getName(), p2.getName());
                if (nameCompResult == 0) {
                    throw new RuntimeException("shoudln't come here");
                }
                return nameCompResult > 0;
            }
        });
        PluginRegistryHelper.reorderSamePriorityPlugins(this.pluginList);
    }

    public void inferencePointToOfExtension() {
        HashSet<String> currentPointNameSet = new HashSet<String>();
        for (int i = 0; i < this.pluginList.size(); ++i) {
            AbstractPlugin p = this.pluginList.get(i);
            for (ExtensionPoint point : p.getExtensionPoints()) {
                currentPointNameSet.add(point.getName());
            }
            for (Extension extension : p.getExtensions()) {
                if (!StringKit.isNull(extension.getExtensionPointName())) continue;
                String result = this.inference(extension, currentPointNameSet);
                if (result == null) {
                    this.errorList.add(new PluginError(p.getName(), "Can't inference extension's pointTo attribute. extension class is:" + extension.getClazz().getName() + "\u3002 " + " In order to inference a extension's pointTo , the clazz must has a direct interface or subclass who's name is an extension point."));
                    continue;
                }
                extension.setRefExtensionPoint(result);
            }
        }
        currentPointNameSet.clear();
        if (this.errorList.size() > 0) {
            throw new RuntimeException(this.errorList.toString());
        }
    }

    private String inference(Extension extension, Set<String> pointNameSet) {
        ArrayList<String> nameList = new ArrayList<String>();
        Class superclass = extension.getClazz().getSuperclass();
        if (!superclass.equals(Object.class)) {
            nameList.add(superclass.getName());
        }
        for (Class<?> c : extension.getClazz().getInterfaces()) {
            nameList.add(c.getName());
        }
        String matched = null;
        for (String name : nameList) {
            if (!pointNameSet.contains(name)) continue;
            if (matched == null) {
                matched = name;
                continue;
            }
            PluginEnvirement.getInstance().getStartLogger().log("ERROR: Dulicate matched when inference pointTo , names:[" + matched + " , " + name + " ]");
            return null;
        }
        if (matched == null) {
            PluginEnvirement.getInstance().getStartLogger().log("ERROR: All of the  names are not extension point when inference pointTo :" + this.printContent(nameList));
        }
        return matched;
    }

    private String printContent(List<String> names) {
        StringBuffer sb = new StringBuffer("[");
        for (String s : names) {
            sb.append(s).append(" , ");
        }
        sb.append("]");
        return sb.toString();
    }

    public void validAndFillExtensionPointMap() {
        this.extensionPointMap.clear();
        for (int i = 0; i < this.pluginList.size(); ++i) {
            AbstractPlugin p = this.pluginList.get(i);
            List<PluginError> ret = p.valid(this);
            if (ret.isEmpty()) continue;
            p.setStatus(-1);
            this.errorList.addAll(ret);
        }
        if (this.errorList.size() > 0) {
            throw new RuntimeException(this.errorList.toString());
        }
    }

    void printPluginSequence(String title) {
        StringBuffer sb = new StringBuffer(title).append("\n");
        for (int i = 0; i < this.pluginList.size(); ++i) {
            AbstractPlugin p = this.pluginList.get(i);
            sb.append("[").append(i).append("] ").append(p.getName()).append(" ").append(p.getPrivority()).append("  ").append("\n");
            for (ExtensionPoint ep : p.getExtensionPoints()) {
                sb.append("  " + ep.getName()).append("\n");
            }
            if (p.getExtensions().size() <= 0) continue;
            sb.append("  {");
            for (Extension e : p.getExtensions()) {
                sb.append(e.getExtensionPointName()).append("  ");
            }
            sb.append("}\n");
        }
        PluginEnvirement.getInstance().getStartLogger().log(sb.toString());
    }

    public void load() {
        AbstractPlugin plugin;
        int i;
        for (i = 0; i < this.pluginList.size(); ++i) {
            plugin = this.pluginList.get(i);
            if (plugin.getStatus() != 0) continue;
            List<PluginError> ret = plugin.load();
            if (ret != null && !ret.isEmpty()) {
                plugin.setStatus(-1);
                this.errorList.addAll(ret);
                continue;
            }
            plugin.setStatus(1);
        }
        for (i = 0; i < this.pluginList.size(); ++i) {
            plugin = this.pluginList.get(i);
            this.loadedPluginMap.put(plugin.getName(), plugin);
        }
    }

    public void wire() {
        this.extensionPointMap.clear();
        for (int i = 0; i < this.pluginList.size(); ++i) {
            AbstractPlugin plugin = this.pluginList.get(i);
            if (plugin.getStatus() != 1) continue;
            plugin.wire(this, this.errorList);
        }
    }

    public void makeServices() {
        PluginEnvirement.INSTANCE.getStartLogger().log("==Now to create services==");
        for (int i = 0; i < this.pluginList.size(); ++i) {
            AbstractPlugin plugin = this.pluginList.get(i);
            if (plugin.getStatus() != 1) continue;
            plugin.onCreateServices();
            PluginEventListenerManager.afterCreateServices(plugin.getName());
        }
    }

    public void start(boolean testAll, String testTarget) {
        PluginEnvirement.INSTANCE.getStartLogger().log("==Now to init plugins==");
        for (int i = 0; i < this.pluginList.size(); ++i) {
            AbstractPlugin plugin = this.pluginList.get(i);
            if (plugin.getStatus() != 1) continue;
            try {
                PluginEnvirement.INSTANCE.getStartLogger().log("StartPlugin :[" + i + "] " + plugin.getName());
                plugin.init();
                if (testAll || !plugin.getName().equals(testTarget)) continue;
                break;
            }
            catch (Exception e) {
                this.errorList.add(new PluginError(plugin.getName(), "error when start," + e.getMessage(), e));
                throw new RuntimeException("error to start:" + plugin.getName(), e);
            }
        }
        PluginEnvirement.INSTANCE.getStartLogger().log("Total " + this.pluginList.size() + " plugin started!");
    }

    private void checkSameName(List<PluginError> eList) {
        HashMap<String, IPlugin> tmp = new HashMap<String, IPlugin>();
        for (int i = 0; i < this.pluginList.size(); ++i) {
            IPlugin p = this.pluginList.get(i);
            String name = p.getName();
            if (StringKit.isNull(name)) {
                eList.add(new PluginError("null", "plugin name is null"));
                continue;
            }
            if (tmp.get(name) != null) {
                eList.add(new PluginError(name, "plugin same name with privious,removed"));
                continue;
            }
            tmp.put(name, p);
        }
    }

    public Map<String, ExtensionPoint> getExtensionPointMap() {
        return this.extensionPointMap;
    }

    public IPlugin getLoadedPlugin(String nm) {
        AbstractPlugin ret = this.loadedPluginMap.get(nm);
        if (ret == null) {
            throw new RuntimeException("the plugin not load correctly :" + nm);
        }
        return ret;
    }

    public void destroy() {
        for (int i = 0; i < this.pluginList.size(); ++i) {
            AbstractPlugin plugin = this.pluginList.get(i);
            try {
                plugin.onDestroy();
                continue;
            }
            catch (Exception e) {
                PluginEnvirement.INSTANCE.getStartLogger().log(e.getMessage(), e);
            }
        }
    }

    public void clearClassCache() {
        for (int i = 0; i < this.pluginList.size(); ++i) {
            AbstractPlugin plugin = this.pluginList.get(i);
            plugin._cleanContainedClasses();
        }
    }

    public void handleDuplicateExtension() {
        HashSet<Extension> tempSet = new HashSet<Extension>();
        for (AbstractPlugin p : this.pluginList) {
            List<Extension> extList = p.getExtensions();
            for (int i = extList.size() - 1; i >= 0; --i) {
                Extension ext = extList.get(i);
                if (tempSet.contains(ext)) {
                    throw new RuntimeException("Warnning: Found dup extension in plugin:" + p.getName() + " ext=" + ext);
                }
                tempSet.add(ext);
            }
        }
        tempSet.clear();
    }

    public void prepare() {
        PluginPrepareHelper.preparePlugins(this.pluginClasses);
    }

    public void construct() {
        for (Class c : this.pluginClasses) {
            try {
                this.pluginList.add((AbstractPlugin)c.newInstance());
            }
            catch (InstantiationException e) {
                throw new RuntimeException("plugin contruct error:" + c.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("plugin contruct error:" + c.getName(), e);
            }
        }
    }

    public List<Class> getPluginClasses() {
        return this.pluginClasses;
    }
}

