/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.kernel.api;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.kernel.api.Extension;
import net.jplugin.core.kernel.api.PluginEnvirement;

public class ExtensionPoint {
    String name;
    Class<?> extensionClass;
    Type type;
    List<Extension> extensions;
    Object[] extensionObjects;
    Map<String, Object> extensionMap;
    private boolean supportPriority = false;

    public static ExtensionPoint createList(String aName, Class<?> clazz) {
        return new ExtensionPoint(aName, clazz, Type.LIST);
    }

    public Type getType() {
        return this.type;
    }

    public static ExtensionPoint createListWithPriority(String aName, Class<?> clazz) {
        ExtensionPoint ep = new ExtensionPoint(aName, clazz, Type.LIST);
        ep.supportPriority = true;
        return ep;
    }

    public static ExtensionPoint createNamed(String aName, Class<?> clazz) {
        return new ExtensionPoint(aName, clazz, Type.NAMED);
    }

    public static ExtensionPoint createNamedWithPriority(String aName, Class<?> clazz) {
        ExtensionPoint ep = ExtensionPoint.createNamed(aName, clazz);
        ep.supportPriority = true;
        return ep;
    }

    public static ExtensionPoint createUnique(String aName, Class<?> clazz) {
        return new ExtensionPoint(aName, clazz, Type.UNIQUE);
    }

    public static ExtensionPoint createUniqueWithPriority(String aName, Class<?> clazz) {
        ExtensionPoint ep = ExtensionPoint.createUnique(aName, clazz);
        ep.supportPriority = true;
        return ep;
    }

    @Deprecated
    public static ExtensionPoint create(String aName, Class<?> clazz) {
        return ExtensionPoint.createList(aName, clazz);
    }

    public boolean supportPriority() {
        return this.type == Type.LIST && this.supportPriority;
    }

    @Deprecated
    public static ExtensionPoint create(String aName, Class<?> clazz, boolean nameUnique) {
        if (nameUnique) {
            return ExtensionPoint.createNamed(aName, clazz);
        }
        return ExtensionPoint.createList(aName, clazz);
    }

    private ExtensionPoint(String aName, Class<?> clazz, Type tp) {
        this.name = aName;
        this.extensionClass = clazz;
        this.extensions = new ArrayList<Extension>();
        this.type = tp;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getExtensionClass() {
        return this.extensionClass;
    }

    private List<Extension> getExtensions() {
        return this.extensions;
    }

    public void addExtension(Extension e) {
        this.extensions.add(e);
    }

    public <T> T getExtension(Class<T> t) {
        if (this.type != Type.UNIQUE) {
            throw new RuntimeException("can't call getExtension when type is not SINGLETON");
        }
        if (this.extensionObjects == null) {
            this.getExtensionObjects(t);
        }
        if (this.extensionObjects == null || this.extensionObjects.length == 0) {
            return null;
        }
        return (T)this.extensionObjects[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T[] getExtensionObjects(Class<T> t) {
        if (this.extensionObjects == null) {
            ExtensionPoint extensionPoint = this;
            synchronized (extensionPoint) {
                if (this.extensionObjects == null) {
                    this.extensionObjects = (Object[])Array.newInstance(this.extensionClass, this.extensions.size());
                    for (int i = 0; i < this.extensionObjects.length; ++i) {
                        this.extensionObjects[i] = this.extensions.get(i).getObject();
                    }
                }
            }
        }
        return this.extensionObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getExtensionMap() {
        if (this.type != Type.NAMED) {
            throw new RuntimeException("can't call getExtensionMap when the extension point is not a NAMED one");
        }
        if (this.extensionMap == null) {
            ExtensionPoint extensionPoint = this;
            synchronized (extensionPoint) {
                if (this.extensionMap == null) {
                    this.extensionMap = new HashMap<String, Object>();
                    for (Extension e : this.extensions) {
                        this.extensionMap.put(e.getName(), e.getObject());
                    }
                }
            }
        }
        return this.extensionMap;
    }

    public String __debugValidAndAdd(Extension ext) {
        return this.validAndAddExtension(ext);
    }

    public List<Extension> __debugGetExtensions() {
        return this.extensions;
    }

    String validAndAddExtension(Extension ext) {
        if (!this.supportPriority && ext.getPriority() != 0) {
            return "The point dones't support priority. the priority must be default value";
        }
        if (this.type == Type.NAMED) {
            if (StringKit.isNull(ext.getName())) {
                return "Named extension must have a name. ";
            }
            for (Extension e : this.extensions) {
                if (!e.getName().equals(ext.getName())) continue;
                if (this.supportPriority) {
                    this.replaceExtensionBaseOnPriority(e, ext);
                    return null;
                }
                return "Named extension must have a unique name.  name duplicate:" + ext.getName();
            }
            this.getExtensions().add(ext);
            return null;
        }
        if (this.type == Type.UNIQUE) {
            if (this.extensions.size() == 1) {
                if (this.supportPriority) {
                    Extension e = this.getExtensions().get(0);
                    this.replaceExtensionBaseOnPriority(e, ext);
                    return null;
                }
                return "Unique extensionPoint can only have one extension";
            }
            if (this.getExtensions().size() == 0) {
                this.getExtensions().add(ext);
                return null;
            }
            throw new RuntimeException("The program can't come here");
        }
        if (this.type == Type.LIST) {
            if (!this.supportPriority) {
                this.getExtensions().add(ext);
                return null;
            }
            this.insertAndKeetOrder(ext);
            return null;
        }
        throw new RuntimeException("The program can't come here");
    }

    private void insertAndKeetOrder(Extension ext) {
        for (int i = this.getExtensions().size() - 1; i >= 0; --i) {
            if (ext.getPriority() < this.getExtensions().get(i).getPriority()) continue;
            this.getExtensions().add(i + 1, ext);
            return;
        }
        this.getExtensions().add(0, ext);
    }

    private void replaceExtensionBaseOnPriority(Extension existsExt, Extension newExt) {
        if (newExt.getPriority() < existsExt.getPriority()) {
            this.logDiscardExtension(existsExt);
            int idx = this.getExtensions().indexOf(existsExt);
            this.getExtensions().remove(existsExt);
            this.getExtensions().add(idx, newExt);
        } else {
            this.logDiscardExtension(newExt);
        }
    }

    private void logDiscardExtension(Extension e) {
        PluginEnvirement.getInstance().getStartLogger().log(" Discard extension because the higher priority extension is found. Point=" + this.getName() + " Discarded: " + e.getClazz() + "," + e.getName());
    }

    public static enum Type {
        NAMED,
        LIST,
        UNIQUE;

    }
}

