/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.config.impl;

import java.util.ArrayList;
import java.util.List;
import net.jplugin.common.kits.StringMatcher;
import net.jplugin.core.config.api.IConfigChangeContext;
import net.jplugin.core.config.api.IConfigChangeHandler;
import net.jplugin.core.config.impl.ConfigChangeHandlerDef;
import net.jplugin.core.kernel.api.PluginEnvirement;

public class ConfigureChangeManager {
    private ConfigChangeHandlerDef[] list;
    public static ConfigureChangeManager instance = new ConfigureChangeManager();

    public void init() {
        for (ConfigChangeHandlerDef o : this.list = PluginEnvirement.getInstance().getExtensionObjects("EP_CONFIG_CHANGE_HANDLER", ConfigChangeHandlerDef.class)) {
            o.setMatcher(new StringMatcher(o.pattern));
            o.setHandlerInstance(this.makeInstance(o.getHandlerClass()));
        }
    }

    private IConfigChangeHandler makeInstance(Class<? extends IConfigChangeHandler> handlerClass) {
        IConfigChangeHandler o;
        try {
            o = handlerClass.newInstance();
            PluginEnvirement.getInstance().resolveRefAnnotation(o);
        }
        catch (Exception e) {
            throw new RuntimeException("init object error:" + handlerClass.getName());
        }
        return o;
    }

    public void fireConfigChange(List<String> keyList) {
        PluginEnvirement.INSTANCE.getStartLogger().log("$$$ Fire config change:" + this.get(keyList));
        for (ConfigChangeHandlerDef en : this.list) {
            if (!this.match(en.matcher, keyList)) continue;
            ConfigChangeContext ctx = ConfigChangeContext.create(en.matcher, keyList);
            en.getHandlerInstance().onChange(ctx);
        }
    }

    private String get(List<String> keyList) {
        StringBuffer sb = new StringBuffer("[");
        for (String k : keyList) {
            sb.append(k).append(" , ");
        }
        sb.append("]");
        return sb.toString();
    }

    private boolean match(StringMatcher m, List<String> keyList) {
        for (String key : keyList) {
            if (!m.match(key)) continue;
            return true;
        }
        return false;
    }

    private static class ConfigChangeContext
    implements IConfigChangeContext {
        StringMatcher matcher;
        List<String> keys;

        private ConfigChangeContext() {
        }

        static ConfigChangeContext create(StringMatcher matcher, List<String> keys) {
            ConfigChangeContext o = new ConfigChangeContext();
            o.matcher = matcher;
            o.keys = keys;
            return o;
        }

        @Override
        public List<String> getChangedKeys() {
            ArrayList<String> result = new ArrayList<String>();
            for (String key : this.keys) {
                if (!this.matcher.match(key)) continue;
                result.add(key);
            }
            if (result.isEmpty()) {
                throw new RuntimeException("No change key found,code shoudln't come here!");
            }
            return result;
        }
    }
}

