/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.core.config.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.config.api.IConfigProvidor;
import net.jplugin.core.kernel.api.PluginEnvirement;

public class ConfigFactory {
    private static IConfigProvidor localConfigProvidor;
    private static IConfigProvidor remoteConfigProvidor;

    public static String getStringConfig(String path, String def) {
        String val = ConfigFactory._getStringConfig(path);
        if (StringKit.isNull(val)) {
            return def;
        }
        return val;
    }

    public static String getStringConfig(String path) {
        return ConfigFactory.getStringConfig(path, null);
    }

    public static String getStringConfigWithTrim(String path) {
        String v = ConfigFactory.getStringConfig(path, null);
        if (v != null) {
            v = v.trim();
        }
        return v;
    }

    public static Long getLongConfig(String path, Long def) {
        String val = ConfigFactory._getStringConfig(path);
        if (StringKit.isNull(val)) {
            return def;
        }
        return Long.parseLong(val);
    }

    public static Long getLongConfig(String path) {
        return ConfigFactory.getLongConfig(path, null);
    }

    public static Integer getIntConfig(String path, Integer def) {
        String val = ConfigFactory._getStringConfig(path);
        if (StringKit.isNull(val)) {
            return def;
        }
        return Integer.parseInt(val);
    }

    public static Integer getIntConfig(String path) {
        return ConfigFactory.getIntConfig(path, null);
    }

    public static Set<String> getGroups() {
        HashSet<String> ret = new HashSet<String>();
        if (remoteConfigProvidor != null) {
            Set<String> temp = remoteConfigProvidor.getGroups();
            ret.addAll(temp);
        }
        ret.addAll(localConfigProvidor.getGroups());
        return ret;
    }

    public static Map<String, String> getStringConfigInGroup(String group) {
        Map<String, String> ret = null;
        if (remoteConfigProvidor != null) {
            ret = remoteConfigProvidor.getStringConfigInGroup(group);
        }
        if (ret == null) {
            ret = new HashMap<String, String>();
        }
        ret.putAll(localConfigProvidor.getStringConfigInGroup(group));
        return ret;
    }

    private static String _getStringConfig(String path) {
        if (localConfigProvidor.containsConfig(path)) {
            return localConfigProvidor.getConfigValue(path);
        }
        if (remoteConfigProvidor != null) {
            return remoteConfigProvidor.getConfigValue(path);
        }
        return null;
    }

    public static void _setLocalConfigProvidor(IConfigProvidor repo) {
        localConfigProvidor = repo;
    }

    public static void _setRemoteConfigProvidor(IConfigProvidor repo) {
        remoteConfigProvidor = repo;
        PluginEnvirement.INSTANCE.getStartLogger().log("$$$ Remote Configigure Providor init:" + repo.getClass().getName());
    }

    static {
        remoteConfigProvidor = null;
    }
}

