/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.common.kits.tuple;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import net.jplugin.common.kits.tuple.Tuple1;
import net.jplugin.common.kits.tuple.Tuple2;
import net.jplugin.common.kits.tuple.Tuple3;
import net.jplugin.common.kits.tuple.Tuple4;
import net.jplugin.common.kits.tuple.TupleN;

public abstract class Tuple
implements Iterable<Object>,
Serializable {
    private final List<Object> valueList;

    Tuple(Object ... objects) {
        this.valueList = Arrays.asList(objects);
    }

    public final List<Object> toList() {
        return new ArrayList<Object>(this.valueList);
    }

    public final Object[] toArray() {
        return this.valueList.toArray();
    }

    public final int size() {
        return this.valueList.size();
    }

    public final Object get(int pos) {
        return this.valueList.get(pos);
    }

    public final boolean contains(Object value) {
        return this.valueList.contains(value);
    }

    @Override
    public final Iterator<Object> iterator() {
        return this.valueList.iterator();
    }

    @Override
    public final Spliterator<Object> spliterator() {
        return this.valueList.spliterator();
    }

    @Override
    public final void forEach(Consumer<? super Object> action) {
        this.valueList.forEach(action);
    }

    public static Tuple withMap(Map<String, Object> map) {
        Objects.requireNonNull(map, "map is null");
        switch (map.size()) {
            case 1: {
                return Tuple1.with(map.get("first"));
            }
            case 2: {
                return Tuple2.with(map.get("first"), map.get("second"));
            }
            case 3: {
                return Tuple3.with(map.get("first"), map.get("second"), map.get("third"));
            }
            case 4: {
                return Tuple4.with(map.get("first"), map.get("second"), map.get("third"), map.get("fourth"));
            }
        }
        return TupleN.with(map.values().toArray());
    }

    public static Tuple withList(List<Object> list) {
        Objects.requireNonNull(list, "list is null");
        switch (list.size()) {
            case 1: {
                return Tuple1.with(list.get(0));
            }
            case 2: {
                return Tuple2.with(list.get(0), list.get(1));
            }
            case 3: {
                return Tuple3.with(list.get(0), list.get(1), list.get(2));
            }
            case 4: {
                return Tuple4.with(list.get(0), list.get(1), list.get(2), list.get(3));
            }
        }
        return TupleN.with(list.toArray());
    }
}

