/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.common.kits;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.jplugin.common.kits.StringKit;
import net.jplugin.common.kits.XMLException;
import net.jplugin.common.kits.XMLNodeOperation;
import net.jplugin.common.kits.XMLRunTimeException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLKit {
    static final String ENCODING_STR = "encoding";
    private static DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private static Document emptyDom;

    public static final Document getSystemEmptyDom() {
        return emptyDom;
    }

    public static final Document createDocument(String rootElement) {
        Document doc = XMLKit.newDocument();
        Element el = doc.createElement(rootElement);
        doc.appendChild(el);
        return doc;
    }

    public static final Document createDocument() {
        return XMLKit.newDocument();
    }

    private static Document newDocument() throws XMLRunTimeException {
        return XMLKit.getXMLBuilder().newDocument();
    }

    private static final DocumentBuilder getXMLBuilder() throws XMLRunTimeException {
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db;
        }
        catch (ParserConfigurationException e) {
            throw new XMLRunTimeException(e.getMessage());
        }
    }

    public static final Document parseStreamWithEncode(ClassLoader cl, String resource, String encode) throws XMLException {
        InputStream stream = cl.getResourceAsStream(resource);
        try {
            String sdom = StringKit.changeStreamToString(stream, encode);
            Document document = XMLKit.parseString(sdom);
            return document;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new XMLException("Parse Stream With Encode Error! msg=" + e.getMessage());
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static final Document parseStreamWithEncode(Class cls, String resourceName, String encode) throws XMLException {
        InputStream stream = cls.getResourceAsStream(resourceName);
        try {
            String sdom = StringKit.changeStreamToString(stream, encode);
            Document document = XMLKit.parseString(sdom);
            return document;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new XMLException("Parse Stream With Encode Error! msg=" + e.getMessage());
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static final Document parseFile(String filePath) throws XMLException {
        try {
            Document doc = XMLKit.parseXMLFile(filePath);
            if (doc == null) {
                throw new XMLRunTimeException("Can't parse file:" + filePath);
            }
            return doc;
        }
        catch (Exception e) {
            throw new XMLException("\u89e3\u6790\u6587\u4ef6\u9519\u8bef filePath=[" + filePath + "]  " + e.getMessage());
        }
    }

    private static Document parseXMLFile(String file) {
        FileInputStream is = null;
        try {
            Document document;
            is = new FileInputStream(file);
            Document document2 = document = XMLKit.getXMLBuilder().parse(is);
            return document2;
        }
        catch (Exception e) {
            throw new XMLRunTimeException(file == null ? "file is null" : new File(file).getAbsolutePath());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static final Document parseString(String xmlString) throws XMLException {
        try {
            if (xmlString == null) {
                return null;
            }
            String encoding = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
            if (!xmlString.startsWith("<?")) {
                xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + xmlString;
            } else {
                String oneStr = xmlString.substring(xmlString.indexOf("<?"), xmlString.indexOf(">") + 1);
                if (oneStr.indexOf(ENCODING_STR) == -1) {
                    xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + xmlString.substring(oneStr.length());
                }
            }
            return XMLKit.innerParseString(xmlString);
        }
        catch (Exception e) {
            throw new XMLException("\u89e3\u6790\u5b57\u7b26\u4e32\u9519\u8bef xmlString=[" + xmlString + "]  " + e.getMessage());
        }
    }

    private static Document innerParseString(String xml) {
        String header = XMLKit.stringXMLHeader(xml);
        String encoding = XMLKit.xmlEncoding(header);
        return XMLKit.parseStringThrowsException(xml, encoding);
    }

    private static final Document parseStringThrowsException(String xml, String encoding) throws RuntimeException {
        try {
            ByteArrayInputStream bais = null;
            bais = encoding == null ? new ByteArrayInputStream(xml.getBytes()) : new ByteArrayInputStream(xml.getBytes(encoding));
            return XMLKit.getXMLBuilder().parse(bais);
        }
        catch (Exception e) {
            throw new XMLRunTimeException(e);
        }
    }

    private static String stringXMLHeader(String xml) {
        int end;
        int start = xml.indexOf("<?");
        if (start != -1 && xml.substring(0, start).trim().length() <= 2 && (end = xml.indexOf("?>", start)) != -1) {
            return xml.substring(start, end + 2);
        }
        return null;
    }

    private static String xmlEncoding(String header) {
        if (header == null || header.equals("")) {
            return null;
        }
        int op = header.indexOf(ENCODING_STR);
        if (op == -1) {
            return null;
        }
        if ((op = header.indexOf("\"", op)) == -1) {
            return null;
        }
        String tmp = header.substring(op + "\"".length());
        if ((op = tmp.indexOf("\"")) == -1) {
            return null;
        }
        tmp = tmp.substring(0, op);
        return tmp.trim();
    }

    public static void setNodeValue(Node nd, String value) throws XMLRunTimeException {
        if (nd.getNodeType() == 2) {
            nd.setNodeValue(value);
        } else if (nd.getNodeType() == 1) {
            NodeList nl = nd.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                nd.removeChild(nl.item(i));
            }
            nd.appendChild(nd.getOwnerDocument().createTextNode(value));
        } else {
            throw new XMLRunTimeException("\u8bbe\u5b9a\u8282\u70b9\u503c\u9519\u8bef,\u5fc5\u987b\u4e3aAttributeNode \u6216\u8005Element Node");
        }
    }

    public static final String getNodeValue(Node nd) throws XMLRunTimeException {
        if (nd.getNodeType() == 2) {
            return nd.getNodeValue();
        }
        if (nd.getNodeType() == 1) {
            Node child = nd.getFirstChild();
            if (child == null) {
                return "";
            }
            if (child.getNodeType() == 3) {
                return child.getNodeValue();
            }
            NodeList nl = nd.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                if (nl.item(i).getNodeType() != 3) continue;
                return nl.item(i).getNodeValue();
            }
            return "";
        }
        throw new XMLRunTimeException("\u83b7\u53d6\u8282\u70b9\u503c\u9519\u8bef,\u5fc5\u987b\u4e3aAttribute Node \u6216\u8005Element Node. but nodetype = " + nd.getNodeType());
    }

    public static void setChildNodeValue(Element node, String childName, String value) {
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1 || !nl.item(i).getNodeName().equals(childName)) continue;
            XMLKit.setNodeValue((Element)nl.item(i), value);
            return;
        }
        XMLKit.appendChild(node, childName, value);
    }

    public static void removeAllChild(Node node) {
        if (node != null) {
            NodeList nl = node.getChildNodes();
            for (int i = nl.getLength(); i > 0; --i) {
                node.removeChild(nl.item(i - 1));
            }
        }
    }

    public static Element appendChild(Element elem, String childName, String childValue) {
        Element nd = (Element)elem.appendChild(elem.getOwnerDocument().createElement(childName));
        if (childValue != null) {
            XMLKit.setNodeValue(nd, childValue);
        }
        return nd;
    }

    public static Element appendChild(Node ndT, String childName) {
        Element nd = ndT.getOwnerDocument().createElement(childName);
        ndT.appendChild(nd);
        return nd;
    }

    public static Element getFirstChildElement(Element nd) {
        NodeList nl = nd.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            return (Element)nl.item(i);
        }
        return null;
    }

    public static Element getElement(Element parentNode, String nodeName) {
        if (parentNode == null) {
            return null;
        }
        NodeList nl = parentNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1 || !nl.item(i).getNodeName().equals(nodeName)) continue;
            return (Element)nl.item(i);
        }
        return null;
    }

    public static Element getLastElement(Element parentNode, String nodeName) {
        if (parentNode == null) {
            return null;
        }
        NodeList nl = parentNode.getChildNodes();
        for (int i = nl.getLength() - 1; i >= 0; --i) {
            if (nl.item(i).getNodeType() != 1 || !nl.item(i).getNodeName().equals(nodeName)) continue;
            return (Element)nl.item(i);
        }
        return null;
    }

    public static List getAllChildElements(Element parentNode) {
        NodeList nl = parentNode.getChildNodes();
        ArrayList<Node> retList = new ArrayList<Node>();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            retList.add(nl.item(i));
        }
        return retList;
    }

    public static List getChildElements(Element parentNode, String nodeName) {
        if (parentNode == null) {
            return null;
        }
        ArrayList<Node> retList = new ArrayList<Node>();
        NodeList nl = parentNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1 || !nl.item(i).getNodeName().equals(nodeName)) continue;
            retList.add(nl.item(i));
        }
        return retList;
    }

    public static Element getElementByAttribute(Element parentNode, String nodeName, String AttrName, String AttrValue) {
        if (parentNode == null) {
            return null;
        }
        List ve = XMLKit.getChildElements(parentNode, nodeName);
        for (int i = 0; i < ve.size(); ++i) {
            if (!((Element)ve.get(i)).getAttribute(AttrName).equals(AttrValue)) continue;
            return (Element)ve.get(i);
        }
        return null;
    }

    public static Element getElementByFieldValue(Element parentNode, String nodeName, String fieldName, String fieldValue) throws XMLException {
        if (parentNode == null) {
            return null;
        }
        List ve = XMLKit.getChildElements(parentNode, nodeName);
        for (int i = 0; i < ve.size(); ++i) {
            if (!XMLKit.cNull(XMLKit.getNodeValue((Element)ve.get(i), fieldName)).equals(fieldValue)) continue;
            return (Element)ve.get(i);
        }
        return null;
    }

    private static String getNodeValue(Element element, String fieldName) {
        Element child = XMLKit.getElement(element, fieldName);
        if (child == null) {
            return null;
        }
        return XMLKit.getNodeValue(element);
    }

    public static void travelNode(Node nd, XMLNodeOperation xo) {
        if (nd == null) {
            return;
        }
        xo.disposeNode(nd);
        if (nd.getNodeType() == 1) {
            NamedNodeMap nnm = nd.getAttributes();
            int nnmlen = nnm.getLength();
            for (int i = 0; i < nnmlen; ++i) {
                Node nnmi = nnm.item(i);
                XMLKit.travelNode(nnmi, xo);
            }
            NodeList nl = nd.getChildNodes();
            int nll = nl.getLength();
            for (int i = 0; i < nll; ++i) {
                Node nli = nl.item(i);
                XMLKit.travelNode(nli, xo);
            }
        } else if (nd.getNodeType() == 9) {
            XMLKit.travelNode(nd.getChildNodes().item(0), xo);
        }
    }

    private static String cNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static Node importOrCloneNode(Document dom, Node node) {
        if (dom == node.getOwnerDocument()) {
            return node.cloneNode(true);
        }
        return dom.importNode(node, true);
    }

    public static Node condImportNode(Document ownerDocument, Node node) {
        if (ownerDocument == node.getOwnerDocument()) {
            return node;
        }
        return ownerDocument.importNode(node, true);
    }

    public static HashMap getTextPathValues(final Element rootNode) {
        final HashMap hm = new HashMap();
        XMLKit.travelNode(rootNode, new XMLNodeOperation(){

            public String getNodePath(Element root, Node nd) {
                String path = "";
                Node pathElem = nd;
                do {
                    pathElem = pathElem.getParentNode();
                    String pathStep = "/";
                    pathStep = pathStep + ((Element)pathElem).getTagName();
                    if (((Element)pathElem).hasAttribute("name")) {
                        pathStep = pathStep + "[@name='" + ((Element)pathElem).getAttribute("name") + "']";
                    }
                    path = pathStep + path;
                } while (pathElem != root);
                return path;
            }

            @Override
            public void disposeNode(Node nd) {
                if (nd.getNodeType() == 3 && nd.getParentNode().getChildNodes().getLength() == 1) {
                    hm.put(this.getNodePath(rootNode, nd), nd.getNodeValue());
                }
            }
        });
        return hm;
    }

    public static String node2String(Node nd) {
        String xmlStr = "";
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.setOutputProperty(ENCODING_STR, "GBK");
            t.setOutputProperty("indent", "yes");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            t.transform(new DOMSource(nd), new StreamResult(bos));
            xmlStr = bos.toString();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return xmlStr;
    }

    public static void main(String[] args) {
        Document dom = XMLKit.createDocument("root");
        System.out.println(dom);
    }

    static {
        dbf.setIgnoringElementContentWhitespace(true);
        emptyDom = XMLKit.createDocument("EMPTY");
    }
}

