/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.common.kits;

import net.jplugin.common.kits.AssertKit;
import net.jplugin.common.kits.StringKit;

public class StringMatcher {
    MatcherMode mode;
    String value;
    StringMatcher[] childsMatcher;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ ").append((Object)this.mode).append(",");
        if (this.mode != MatcherMode.COMPOSITE) {
            sb.append(this.value);
        } else {
            for (StringMatcher o : this.childsMatcher) {
                sb.append(o);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public StringMatcher(String format) {
        if (StringKit.isNull(format) || "*".equals(format)) {
            this.mode = MatcherMode.NONE;
            this.value = null;
        } else if (format.indexOf(124) >= 0) {
            String[] itemArr;
            if (format.startsWith("|") || format.endsWith("|")) {
                throw new RuntimeException("format error:" + format);
            }
            this.mode = MatcherMode.COMPOSITE;
            for (String s : itemArr = StringKit.splitStr(format, "|")) {
                AssertKit.assertStringNotNull(s, " format error:" + format);
            }
            this.childsMatcher = new StringMatcher[itemArr.length];
            for (int i = 0; i < itemArr.length; ++i) {
                this.childsMatcher[i] = new StringMatcher(itemArr[i]);
            }
        } else {
            String value;
            MatcherMode mode;
            if (format.startsWith("*")) {
                mode = MatcherMode.POSTFIX;
                value = format.substring(1);
            } else if (format.endsWith("*")) {
                mode = MatcherMode.PREFIX;
                value = format.substring(0, format.length() - 1);
            } else {
                mode = MatcherMode.EQUAL;
                value = format;
            }
            if (!this.checkValue(value)) {
                throw new RuntimeException("Method Filter str is bat format:" + format);
            }
            this.mode = mode;
            this.value = value;
        }
    }

    public boolean match(String str) {
        if (this.mode == MatcherMode.COMPOSITE) {
            if (this.childsMatcher == null) {
                throw new RuntimeException("Can't go here");
            }
            for (StringMatcher m : this.childsMatcher) {
                if (!m.match(str)) continue;
                return true;
            }
            return false;
        }
        switch (this.mode) {
            case NONE: {
                return true;
            }
            case EQUAL: {
                return this.value.equals(str);
            }
            case POSTFIX: {
                return str.endsWith(this.value);
            }
            case PREFIX: {
                return str.startsWith(this.value);
            }
        }
        throw new RuntimeException("error value:" + (Object)((Object)this.mode));
    }

    private boolean checkValue(String value) {
        if (StringKit.isNull(value)) {
            return false;
        }
        return value.indexOf(42) < 0;
    }

    private static enum MatcherMode {
        NONE,
        POSTFIX,
        PREFIX,
        EQUAL,
        COMPOSITE;

    }
}

