/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.common.kits;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jplugin.common.kits.AssertKit;
import net.jplugin.common.kits.PritiveKits;
import net.jplugin.common.kits.ReflactKit;
import net.jplugin.common.kits.StringKit;

public class ObjectKit {
    public static <T> List<T> findList(Object o, String path, Class<T> t) {
        return (List)ObjectKit.findObject(o, path);
    }

    public static <T> Map<String, T> findMap(Object o, String path, Class<T> t) {
        return (Map)ObjectKit.findObject(o, path);
    }

    public static Object findObject(Object o, String path) {
        PathSegment[] segs = ObjectKit.parse(path);
        Object tmp = o;
        try {
            for (int i = 0; i < segs.length; ++i) {
                if ((tmp = ObjectKit.findBySeg(tmp, segs[i])) != null) continue;
                return null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error to get object,path=" + path + " o=" + o.getClass().getName(), e);
        }
        return tmp;
    }

    private static Object findBySeg(Object o, PathSegment p) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (!StringKit.isNull(p.tag)) {
            o = ObjectKit.getProperty(o, p.tag);
        }
        if (p.attr == null) {
            return o;
        }
        if (p.attr.equals("__INDEX")) {
            int pos = Integer.parseInt(p.value);
            if (pos < 0) {
                pos = ((List)o).size() + pos;
            }
            return ((List)o).get(pos);
        }
        List list = (List)o;
        for (Object item : list) {
            Object ret = ObjectKit.getProperty(item, p.attr);
            PritiveKits.Transformer transformer = PritiveKits.getTransformer(ret.getClass());
            if (transformer == null) {
                throw new RuntimeException(ret.getClass() + " is not a primative type");
            }
            if (!p.value.equals(transformer.convertToString(ret))) continue;
            return item;
        }
        return o;
    }

    private static Object getProperty(Object item, String attr) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (item instanceof Map) {
            return ((Map)item).get(attr);
        }
        Method m = ReflactKit.getGetterMethod(item.getClass(), attr);
        return m.invoke(item, new Object[0]);
    }

    public static PathSegment[] parse(String path) {
        if (path == null || path.trim().equals("")) {
            throw new RuntimeException("error path:" + path);
        }
        String[] paths = path.split("/");
        PathSegment[] ret = new PathSegment[paths.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new PathSegment(paths[i]);
        }
        return ret;
    }

    public static void main(String[] args) {
        ObjectKit.print("[11]");
        ObjectKit.print("a/b/c/d/e");
        ObjectKit.print("a");
        AssertKit.assertException(new Runnable(){

            @Override
            public void run() {
                ObjectKit.parse("");
            }
        });
        ObjectKit.print("b[1]/b[-1]/b[@a=11]/b[@a='11']/b[@a=\"11\"]");
        ObjectKit.print("  b  [@ a =  \"11\"   ]   ");
        ObjectKit.print("b[@a=\"11\"\"]");
        AssertKit.assertException(new Runnable(){

            @Override
            public void run() {
                ObjectKit.print("b[@a='11]");
            }
        });
        AssertKit.assertException(new Runnable(){

            @Override
            public void run() {
                ObjectKit.print("b[@a=11']");
            }
        });
        AssertKit.assertException(new Runnable(){

            @Override
            public void run() {
                ObjectKit.print("b[@a=\"11]");
            }
        });
        AssertKit.assertException(new Runnable(){

            @Override
            public void run() {
                ObjectKit.print("b[@a=11\"]");
            }
        });
        AssertKit.assertException(new Runnable(){

            @Override
            public void run() {
                ObjectKit.print("b[@a='11\"]");
            }
        });
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        HashMap<String, String> map2 = new HashMap<String, String>();
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        map2.put("x", "xvalue");
        map1.put("a", "avalue");
        map1.put("map", map2);
        map1.put("list", list1);
        ArrayList<Object> list2 = new ArrayList<Object>();
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("age", "100");
        list2.add(m);
        m = new HashMap();
        m.put("age", 200);
        list2.add(m);
        Person p = new Person();
        p.age = 300;
        list2.add(p);
        map1.put("list2", list2);
        AssertKit.assertEqual(ObjectKit.findObject(map1, "a"), "avalue");
        AssertKit.assertEqual(ObjectKit.findObject(map1, "map/x"), "xvalue");
        AssertKit.assertEqual(ObjectKit.findObject(map1, "list/[1]"), "1");
        AssertKit.assertEqual(ObjectKit.findObject(map1, "list[-1]"), "2");
        AssertKit.assertEqual(ObjectKit.findObject(map1, "list2[@age=200]/age"), 200);
        AssertKit.assertEqual(ObjectKit.findObject(map1, "list2/[@age=100]/age"), "100");
        AssertKit.assertEqual(ObjectKit.findObject(map1, "list2/[@age='300']/age"), 300);
    }

    private static void print(String path) {
        System.out.println(" path:" + path);
        PathSegment[] segs = ObjectKit.parse(path);
        for (int i = 0; i < segs.length; ++i) {
            System.out.println(segs[i]);
        }
        System.out.println();
    }

    static class Person {
        int age;

        Person() {
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }
    }

    static class PathSegment {
        static final String ATTR_IDX = "__INDEX";
        String tag;
        String attr;
        String value;

        public String toString() {
            return "tag=[" + this.tag + "] attr=[" + this.attr + "] value=[" + this.value + "]";
        }

        public PathSegment(String s) {
            if (s == null || s.equals("")) {
                throw new RuntimeException("error path:" + s);
            }
            if ((s = s.trim()).endsWith("]")) {
                int leftKHPos = s.indexOf("[");
                this.tag = s.substring(0, leftKHPos).trim();
                String attrString = s.substring(leftKHPos + 1, s.length() - 1);
                if (attrString.startsWith("@")) {
                    int dhPos = attrString.indexOf("=");
                    this.attr = this.decode(attrString.substring(0, dhPos));
                    this.attr = this.attr.substring(1);
                    this.attr = this.attr.trim();
                    this.value = this.decode(attrString.substring(dhPos + 1));
                    if (this.attr == null || this.attr.equals("")) {
                        throw new RuntimeException("path error:" + s);
                    }
                    if (this.value == null || this.value.equals("")) {
                        throw new RuntimeException("path error:" + s);
                    }
                } else {
                    if (!StringKit.isNumAllowNig(attrString = attrString.trim())) {
                        throw new RuntimeException("path error:" + s);
                    }
                    this.attr = ATTR_IDX;
                    this.value = attrString;
                }
            } else {
                this.tag = s.trim();
            }
        }

        private String decode(String s) {
            if (s == null) {
                return null;
            }
            s = s.trim();
            char c1 = s.charAt(0);
            char c2 = s.charAt(s.length() - 1);
            if (!(c1 == '\'' && c2 == '\'' || c1 == '\"' && c2 == '\"' || c1 != '\'' && c1 != '\"' && c2 != '\'' && c2 != '\"')) {
                throw new RuntimeException("path error:" + s);
            }
            if (s.startsWith("'")) {
                if (!s.endsWith("'") || s.length() < 2) {
                    // empty if block
                }
                s = s.substring(1, s.length() - 1);
            } else if (s.startsWith("\"")) {
                if (!s.endsWith("\"") || s.length() < 2) {
                    throw new RuntimeException("path error:" + s);
                }
                s = s.substring(1, s.length() - 1);
            }
            return s;
        }
    }
}

