/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.mtenant.impl.kit.parse.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.jplugin.mtenant.impl.kit.parse.SqlParser;
import net.jplugin.mtenant.impl.kit.util.SqlHelper;
import net.jplugin.mtenant.impl.kit.util.StringUtils;

public class UpdateSqlParser
implements SqlParser {
    @Override
    public String parse(String sourceSql, Map<String, Object> params, List<String> ignoreTables) {
        if (params.isEmpty()) {
            return sourceSql;
        }
        String sql = SqlHelper.format(sourceSql);
        if (!StringUtils.startsWith(sql, "update")) {
            return sql;
        }
        String[] sqlArray = StringUtils.split(sql, " ");
        if (ignoreTables == null) {
            ignoreTables = new ArrayList<String>();
        }
        if (!StringUtils.contains(sql, "where") && !ignoreTables.contains(sqlArray[1])) {
            return sql + " " + SqlHelper.createWhere(params, "N");
        }
        int length = sqlArray.length;
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        for (int i = 0; i < length; ++i) {
            String tableName;
            if ("update".equals(sqlArray[i])) {
                tableName = sqlArray[i + 1];
                if (ignoreTables.contains(tableName)) continue;
                int wherePos = this.findFirst(sqlArray, "where");
                map.put(wherePos + 1, "Y");
            }
            if (!"from".equals(sqlArray[i]) || ignoreTables.contains(tableName = sqlArray[i + 1])) continue;
            if (i + 2 == length) {
                map.put(i + 2, "N");
                continue;
            }
            if ("where".equals(sqlArray[i + 2])) {
                map.put(i + 3, "Y");
                continue;
            }
            map.put(i + 2, "N");
        }
        if (map.size() == 0) {
            return sourceSql;
        }
        NavigableMap nmap = map.descendingMap();
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(sqlArray));
        Iterator iterator = nmap.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (i + 1 <= list.size()) {
                list.add(i, SqlHelper.createWhere(params, (String)nmap.get(i)));
                continue;
            }
            list.add(SqlHelper.createWhere(params, (String)nmap.get(i)));
        }
        return SqlHelper.toSql(list);
    }

    private int findFirst(String[] array, String item) {
        for (int i = 0; i < array.length; ++i) {
            if (!item.equals(array[i])) continue;
            return i;
        }
        return 0;
    }
}

