/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.mtenant.impl.kit.parse.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Stack;
import java.util.TreeMap;
import net.jplugin.mtenant.impl.kit.parse.SqlParser;
import net.jplugin.mtenant.impl.kit.util.SqlHelper;
import net.jplugin.mtenant.impl.kit.util.StringUtils;

public class SelectSqlParser
implements SqlParser {
    @Override
    public String parse(String sourceSql, Map<String, Object> params, List<String> ignoreTables) {
        if (params.isEmpty()) {
            return sourceSql;
        }
        if (!sourceSql.contains("from")) {
            return sourceSql;
        }
        String returnSql = SqlHelper.format(sourceSql);
        if (returnSql.contains("union all")) {
            String preSql = SqlHelper.format(returnSql.substring(0, returnSql.indexOf("union all")));
            String subSql = SqlHelper.format(returnSql.substring(returnSql.indexOf("union all")).replace("union all", ""));
            returnSql = this.parse(preSql, params, ignoreTables) + " union all " + this.parse(subSql, params, ignoreTables);
        } else {
            returnSql = !returnSql.contains("(") ? this.preParse(returnSql, params, ignoreTables) : this.dealBracket(returnSql, params, ignoreTables);
        }
        boolean havePlatform = false;
        for (Map.Entry entry : params.entrySet()) {
            if (!returnSql.contains((CharSequence)entry.getKey())) continue;
            havePlatform = true;
            break;
        }
        boolean haveIgnore = false;
        if (!havePlatform) {
            for (String ignore : ignoreTables) {
                if (!returnSql.contains(ignore)) continue;
                haveIgnore = true;
                break;
            }
        }
        if (!(haveIgnore || havePlatform || returnSql.contains("from"))) {
            throw new IllegalArgumentException("SQL parse error");
        }
        return returnSql;
    }

    public String preParse(String sourceSql, Map<String, Object> params, List<String> ignoreTables) {
        String[] tables;
        int i;
        if (params.isEmpty()) {
            return sourceSql;
        }
        if (!sourceSql.contains("select")) {
            return sourceSql;
        }
        String[] sqlArray = StringUtils.split(sourceSql, " ");
        if (ignoreTables == null) {
            ignoreTables = new ArrayList<String>();
        }
        boolean whereIf = false;
        int length = sqlArray.length;
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        HashSet<String> aliasList = new HashSet<String>();
        int fromPosition = 0;
        int wherePosition = 0;
        int beforeByPosition = length;
        for (int i2 = 0; i2 < length; ++i2) {
            if ("from".equals(sqlArray[i2])) {
                fromPosition = i2;
                if (i2 + 1 == length) {
                    throw new RuntimeException("error sql: " + sourceSql);
                }
            }
            if (("limit".equals(sqlArray[i2]) || ("order".equals(sqlArray[i2]) || "group".equals(sqlArray[i2])) && "by".equals(sqlArray[i2 + 1])) && i2 < beforeByPosition) {
                beforeByPosition = i2;
            }
            if (!"where".equals(sqlArray[i2])) continue;
            wherePosition = i2;
            map.put(i2 + 1, "Y");
            whereIf = true;
        }
        StringBuilder sb = new StringBuilder();
        if (whereIf) {
            for (i = fromPosition + 1; i < wherePosition; ++i) {
                if ("as".equals(sqlArray[i]) || "on".equals(sqlArray[i]) || sqlArray[i].contains(".") || sqlArray[i].equals("=") || sqlArray[i].equals("join") || sqlArray[i].equals("and") || sqlArray[i].equals("or")) continue;
                if (("left".equals(sqlArray[i]) || "right".equals(sqlArray[i]) || "inner".equals(sqlArray[i]) || "full".equals(sqlArray[i])) && "join".equals(sqlArray[i + 1])) {
                    sb.append(",");
                    continue;
                }
                sb.append(sqlArray[i]).append(" ");
            }
        }
        if (wherePosition == 0) {
            for (i = fromPosition + 1; i < beforeByPosition; ++i) {
                if ("as".equals(sqlArray[i]) || "on".equals(sqlArray[i]) || sqlArray[i].contains(".") || sqlArray[i].equals("=") || sqlArray[i].equals("join") || sqlArray[i].equals("and") || sqlArray[i].equals("or")) continue;
                if (("left".equals(sqlArray[i]) || "right".equals(sqlArray[i]) || "inner".equals(sqlArray[i]) || "full".equals(sqlArray[i])) && "join".equals(sqlArray[i + 1])) {
                    sb.append(",");
                    continue;
                }
                sb.append(sqlArray[i]).append(" ");
            }
        }
        for (String t : tables = StringUtils.split(sb.toString().trim(), ",")) {
            if (StringUtils.contains(t.trim(), " ")) {
                aliasList.add(StringUtils.split(t.trim(), " ")[1]);
                continue;
            }
            aliasList.add(t.trim());
        }
        if (0 < aliasList.size()) {
            HashMap<String, Object> bridgeMap = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                for (String alias : aliasList) {
                    if (ignoreTables.contains(alias) || alias.startsWith("tempT_able_")) continue;
                    bridgeMap.put(alias + "." + entry.getKey(), entry.getValue());
                }
            }
            params = bridgeMap;
        }
        ArrayList<String> bracketList = new ArrayList<String>();
        if (!whereIf) {
            map.put(beforeByPosition, "N");
        } else {
            bracketList.addAll(Arrays.asList(sqlArray));
            bracketList.add(wherePosition + 1, "(");
            bracketList.add(beforeByPosition + 1, ")");
        }
        if (map.size() == 0) {
            return sourceSql;
        }
        NavigableMap nmap = map.descendingMap();
        ArrayList<String> list = new ArrayList<String>();
        if (0 < bracketList.size()) {
            list.addAll(bracketList);
        } else {
            list.addAll(Arrays.asList(sqlArray));
        }
        Iterator<Object> iterator = nmap.keySet().iterator();
        while (iterator.hasNext()) {
            int i3 = (Integer)iterator.next();
            if (i3 + 1 <= list.size()) {
                list.add(i3, SqlHelper.createWhere(params, (String)nmap.get(i3)));
                continue;
            }
            list.add(SqlHelper.createWhere(params, (String)nmap.get(i3)));
        }
        return SqlHelper.toSql(list);
    }

    public String dealTempTables(String multiSql, Map<String, String> tempTableMap) {
        for (Map.Entry<String, String> tempTable : tempTableMap.entrySet()) {
            multiSql = multiSql.replace(tempTable.getKey(), tempTable.getValue());
        }
        if (multiSql.contains("tempT_able_")) {
            multiSql = this.dealTempTables(multiSql, tempTableMap);
        }
        return multiSql;
    }

    public String dealBracket(String sourceSql, Map<String, Object> params, List<String> ignoreTables) {
        String[] sqlArray = StringUtils.split(sourceSql, " ");
        int length = sqlArray.length;
        Stack<String> subSqlStack = new Stack<String>();
        HashMap<String, String> tempTableMap = new HashMap<String, String>();
        for (int i = 0; i < length; ++i) {
            if (subSqlStack.isEmpty()) {
                subSqlStack.push(sqlArray[i]);
                continue;
            }
            if (sqlArray[i].equals(")")) {
                int stackSize = subSqlStack.size();
                String rightBracket = ")";
                String subPartSql = "";
                for (int j = 0; j < stackSize; ++j) {
                    if (((String)subSqlStack.peek()).equals("(")) {
                        subPartSql = (String)subSqlStack.pop() + this.preParse(subPartSql, params, ignoreTables) + " " + rightBracket;
                        break;
                    }
                    subPartSql = (String)subSqlStack.pop() + " " + subPartSql;
                }
                String tempTableKey = "tempT_able_" + i + "_T";
                tempTableMap.put(tempTableKey, subPartSql);
                subSqlStack.push(tempTableKey);
                continue;
            }
            subSqlStack.push(sqlArray[i]);
        }
        String wholeSql = "";
        int stackLength = subSqlStack.size();
        for (int j = 0; j < stackLength; ++j) {
            wholeSql = (String)subSqlStack.pop() + " " + wholeSql;
        }
        String multiSql = this.preParse(wholeSql, params, ignoreTables);
        multiSql = this.dealTempTables(multiSql, tempTableMap);
        return multiSql;
    }
}

