/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.mtenant.impl.kit.parse.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.jplugin.mtenant.impl.kit.parse.SqlParser;
import net.jplugin.mtenant.impl.kit.util.SqlHelper;
import net.jplugin.mtenant.impl.kit.util.StringUtils;

public class InsertSqlParser
implements SqlParser {
    @Override
    public String parse(String sourceSql, Map<String, Object> params, List<String> ignoreTables) {
        int i;
        String tableName;
        if (params.isEmpty()) {
            return sourceSql;
        }
        String sql = SqlHelper.format(sourceSql);
        if (!StringUtils.startsWith(sql, "insert")) {
            return sql;
        }
        if (sourceSql.contains("select")) {
            throw new IllegalArgumentException("SQL parse error");
        }
        String[] sqlArray = StringUtils.split(sql, " ");
        if (ignoreTables == null) {
            ignoreTables = new ArrayList<String>();
        }
        if (ignoreTables.contains(tableName = sqlArray[2])) {
            return sourceSql;
        }
        int col = 0;
        int paramKeyPosition = 0;
        int length = sqlArray.length;
        Stack<String> subSqlStack = new Stack<String>();
        String valuesString = "";
        String resultSql = "";
        for (i = 0; i < length; ++i) {
            if ("into".equals(sqlArray[i])) {
                paramKeyPosition = i + 3;
            }
            resultSql = resultSql + " " + sqlArray[i];
            if (!"values".equals(sqlArray[i])) continue;
            col = i + 1;
            break;
        }
        for (i = col; i < length; ++i) {
            if (subSqlStack.isEmpty()) {
                subSqlStack.push(sqlArray[i]);
                continue;
            }
            if (SqlHelper.checkFunctionStr(sqlArray[i])) {
                String sqlFunction = sqlArray[i] + sqlArray[++i];
                String leftBracket = sqlArray[++i];
                while (i < length) {
                    sqlFunction = sqlFunction + leftBracket;
                    if (")".equals(leftBracket)) break;
                    leftBracket = sqlArray[++i];
                }
                subSqlStack.push(sqlFunction);
                continue;
            }
            if (sqlArray[i].equals(")")) {
                int stackSize = subSqlStack.size();
                String rightBracket = ")";
                String subPartSql = "";
                for (int j = 0; j < stackSize; ++j) {
                    if (((String)subSqlStack.peek()).equals("(")) {
                        subPartSql = (String)subSqlStack.pop() + " " + this.getParaValue(params) + ", " + subPartSql + rightBracket;
                        break;
                    }
                    subPartSql = (String)subSqlStack.pop() + " " + subPartSql;
                }
                valuesString = valuesString + "," + subPartSql;
                continue;
            }
            subSqlStack.push(sqlArray[i]);
        }
        resultSql = resultSql + valuesString.substring(1);
        String[] resultSqlArray = StringUtils.split(resultSql, " ");
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(resultSqlArray));
        list.add(paramKeyPosition, this.getParaKey(params) + ",");
        return SqlHelper.toSql(list);
    }

    private String getParaKey(Map<String, Object> params) {
        String toReturn = "";
        Iterator<String> iterator = params.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            toReturn = key = iterator.next();
        }
        return toReturn;
    }

    private String getParaValue(Map<String, Object> params) {
        String toReturn = "";
        for (String key : params.keySet()) {
            Object value = params.get(key);
            if (value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof BigDecimal) {
                toReturn = value.toString();
                continue;
            }
            toReturn = "'" + value + "'";
        }
        return toReturn;
    }
}

