/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.mtenant.impl.kit.parse.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.jplugin.mtenant.impl.kit.parse.SqlParser;
import net.jplugin.mtenant.impl.kit.util.SqlHelper;
import net.jplugin.mtenant.impl.kit.util.StringUtils;

public class BakSelectSqlParser
implements SqlParser {
    @Override
    public String parse(String sourceSql, Map<String, Object> params, List<String> ignoreTables) {
        if (params.isEmpty()) {
            return sourceSql;
        }
        String sql = SqlHelper.format(sourceSql);
        if (!StringUtils.startsWith(sql, "select")) {
            return sql;
        }
        String[] sqlArray = StringUtils.split(sql, " ");
        if (ignoreTables == null) {
            ignoreTables = new ArrayList<String>();
        }
        int length = sqlArray.length;
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        TreeMap<Integer, List<String>> tablemap = new TreeMap<Integer, List<String>>();
        HashMap<String, String> aliasmap = new HashMap<String, String>();
        for (int i = 0; i < length; ++i) {
            if (!"from".equals(sqlArray[i])) continue;
            this.checkTable(sqlArray, i + 1, ignoreTables, map, tablemap, aliasmap);
        }
        if (map.size() == 0) {
            return sourceSql;
        }
        NavigableMap nmap = map.descendingMap();
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(sqlArray));
        Iterator iterator = nmap.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (i + 1 <= list.size()) {
                list.add(i, SqlHelper.createWheres(aliasmap, tablemap.get(i), params, (String)nmap.get(i)));
                continue;
            }
            list.add(SqlHelper.createWheres(aliasmap, tablemap.get(i), params, (String)nmap.get(i)));
        }
        return SqlHelper.toSql(list);
    }

    private void checkTable(String[] sqlArray, int pos, List<String> ignoreTables, TreeMap<Integer, String> map, TreeMap<Integer, List<String>> tablemap, Map<String, String> aliasmap) {
        String[] tables;
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean flag = true;
        boolean where = false;
        int position = 0;
        for (int i = pos; i < sqlArray.length; ++i) {
            if ("where".equals(sqlArray[i])) {
                where = true;
                position = i + 1;
                break;
            }
            if (("left".equals(sqlArray[i]) || "right".equals(sqlArray[i]) || "inner".equals(sqlArray[i]) || "full".equals(sqlArray[i])) && "join".equals(sqlArray[i + 1])) {
                flag = false;
            }
            if (")".equals(sqlArray[i]) || "limit".equals(sqlArray[i]) || "order".equals(sqlArray[i]) && "by".equals(sqlArray[i + 1])) {
                position = i;
                break;
            }
            if (!flag) continue;
            sb.append(sqlArray[i]).append(" ");
        }
        if (!where && position == 0) {
            position = sqlArray.length;
        }
        for (String t : tables = StringUtils.split(sb.toString().trim(), ",")) {
            if (StringUtils.contains(t.trim(), " ")) {
                String table = StringUtils.split(t.trim(), " ")[0];
                if (ignoreTables.contains(table)) continue;
                String alias = StringUtils.split(t.trim(), " ")[1];
                list.add(table);
                aliasmap.put(table, alias);
                continue;
            }
            if (ignoreTables.contains(t)) continue;
            list.add(t);
        }
        if (list.size() > 0) {
            map.put(position, where ? "Y" : "N");
            tablemap.put(position, list);
        }
    }
}

