/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.mtenant.impl.kit.parse.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.jplugin.mtenant.impl.kit.parse.SqlParser;
import net.jplugin.mtenant.impl.kit.util.SqlHelper;
import net.jplugin.mtenant.impl.kit.util.StringUtils;

public class BakInsertSqlParser
implements SqlParser {
    @Override
    public String parse(String sourceSql, Map<String, Object> params, List<String> ignoreTables) {
        String tableName;
        if (params.isEmpty()) {
            return sourceSql;
        }
        String sql = SqlHelper.format(sourceSql);
        if (!StringUtils.startsWith(sql, "insert")) {
            return sql;
        }
        String[] sqlArray = StringUtils.split(sql, " ");
        if (ignoreTables == null) {
            ignoreTables = new ArrayList<String>();
        }
        if (ignoreTables.contains(tableName = sqlArray[2])) {
            return sourceSql;
        }
        int val = -1;
        if (StringUtils.equals("(", sqlArray[3])) {
            int col = 4;
            for (int i = 0; i < sqlArray.length; ++i) {
                if (!"values".equals(sqlArray[i])) continue;
                val = i + 2;
            }
            StringBuilder cols = new StringBuilder();
            StringBuilder vals = new StringBuilder();
            for (String key : params.keySet()) {
                cols.append(key).append(",");
                Object value = params.get(key);
                if (value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof BigDecimal) {
                    vals.append(value).append(",");
                    continue;
                }
                vals.append("'").append(value).append("',");
            }
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(Arrays.asList(sqlArray));
            if (val + 1 <= list.size()) {
                list.add(val, vals.toString());
            } else {
                list.add(vals.toString());
            }
            list.add(col, cols.toString());
            return SqlHelper.toSql(list);
        }
        return sourceSql;
    }
}

