/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.ext.webasic.impl.web;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jplugin.core.kernel.api.Beans;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.ext.webasic.api.IControllerSet;
import net.jplugin.ext.webasic.api.ObjectDefine;
import net.jplugin.ext.webasic.impl.web.WebController;

public class WebControllerSet
implements IControllerSet {
    private Map<String, WebController> controllerMap;

    @Override
    public void init() {
        Map<String, ObjectDefine> defs = PluginEnvirement.getInstance().getExtensionMap("EP_WEBCONTROLLER", ObjectDefine.class);
        this.controllerMap = new ConcurrentHashMap<String, WebController>();
        for (Map.Entry<String, ObjectDefine> en : defs.entrySet()) {
            WebController controller = new WebController(en.getValue());
            this.controllerMap.put(en.getKey(), controller);
            Beans.resetValue(en.getValue(), controller.getObject());
        }
    }

    public Map<String, WebController> getControllerMap() {
        return this.controllerMap;
    }

    @Override
    public Set<String> getAcceptPaths() {
        return this.controllerMap.keySet();
    }

    @Override
    public void dohttp(String path, HttpServletRequest req, HttpServletResponse res, String innerPath) throws Throwable {
        this.controllerMap.get(path).dohttp(path, req, res, innerPath);
    }
}

