/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.ext.webasic.impl.restm.invoker;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.jplugin.common.kits.JsonKit;
import net.jplugin.common.kits.ReflactKit;
import net.jplugin.common.kits.SerializKit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.common.kits.tuple.Tuple2;
import net.jplugin.core.config.api.ConfigFactory;
import net.jplugin.core.config.api.RefConfig;
import net.jplugin.core.ctx.api.JsonResult;
import net.jplugin.core.ctx.api.RuleServiceFactory;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.core.kernel.api.RefAnnotationSupport;
import net.jplugin.core.kernel.api.ctx.RequesterInfo;
import net.jplugin.core.kernel.api.ctx.ThreadLocalContextManager;
import net.jplugin.core.log.api.ILogService;
import net.jplugin.core.rclient.api.RemoteExecuteException;
import net.jplugin.core.rclient.handler.RestHandler;
import net.jplugin.core.service.api.ServiceFactory;
import net.jplugin.ext.webasic.api.IDynamicService;
import net.jplugin.ext.webasic.api.InvocationContext;
import net.jplugin.ext.webasic.api.ObjectDefine;
import net.jplugin.ext.webasic.api.Para;
import net.jplugin.ext.webasic.impl.RemoteExceptionKits;
import net.jplugin.ext.webasic.impl.filter.IMethodCallback;
import net.jplugin.ext.webasic.impl.filter.MethodIllegleAccessException;
import net.jplugin.ext.webasic.impl.filter.service.ServiceFilterManager;
import net.jplugin.ext.webasic.impl.helper.ObjectCallHelper;
import net.jplugin.ext.webasic.impl.restm.RestMethodState;
import net.jplugin.ext.webasic.impl.restm.invoker.CallParam;
import net.jplugin.ext.webasic.impl.restm.invoker.IServiceInvoker;
import net.jplugin.ext.webasic.impl.restm.invoker.JsonCallHelper;

public class ServiceInvoker
extends RefAnnotationSupport
implements IServiceInvoker {
    ObjectCallHelper helper;
    static HashMap<Class, Object> nullDefaultMap = new HashMap();
    static Class[] dynamicParamTypes;
    @RefConfig(path="platform.service-export-format", defaultValue="1")
    Integer service_export_format;
    static Boolean restCompatibleReturn;

    public ServiceInvoker(ObjectDefine d) {
        this.helper = new ObjectCallHelper(d);
        this.validate(this.helper);
    }

    private void validate(ObjectCallHelper helper) {
        Method[] methods;
        Object o = helper.getObject();
        for (Method m : methods = o.getClass().getMethods()) {
            Annotation[][] annos;
            Annotation[][] annotationArray = annos = m.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] arr;
                for (Annotation a : arr = annotationArray[i]) {
                    if (!(a instanceof Para)) continue;
                    Para p = (Para)a;
                    if ("callback".equals(p.name())) {
                        throw new RuntimeException("Param annotation can't use same name with Jsonp callback param. " + o.getClass().getName() + " " + m.getName());
                    }
                    if (!"_FULL_MATCH_".equals(p.name()) || m.getParameterTypes().length == 1) continue;
                    throw new RuntimeException("_FULL_MATCH_ can only be used for method with ONE parameter. " + o.getClass().getName() + " " + m.getName());
                }
            }
        }
    }

    private Object[] getParaValueFromRequest(CallParam req, Annotation[][] paraAnootation, Class<?>[] parameterTypes) {
        if (paraAnootation.length != parameterTypes.length) {
            throw new RuntimeException("Method mismatch!");
        }
        Object[] ret = new Object[parameterTypes.length];
        if (this.tryDuleFullMatch(req, ret, paraAnootation, parameterTypes)) {
            return ret;
        }
        Map<String, String> paraMap = req.getParamMap();
        for (int i = 0; i < parameterTypes.length; ++i) {
            ParaInfo paraInfo = this.getParaInfo(paraAnootation[i], i);
            ret[i] = this.getFromRequest(paraMap, paraInfo, parameterTypes[i], i);
        }
        return ret;
    }

    private boolean tryDuleFullMatch(CallParam req, Object[] ret, Annotation[][] annos, Class<?>[] parameterTypes) {
        Annotation[] anno;
        if (ret.length != 1) {
            return false;
        }
        for (Annotation a : anno = annos[0]) {
            String jsonContent;
            String name;
            if (a.annotationType() != Para.class || !"_FULL_MATCH_".equals(name = ((Para)a).name().trim())) continue;
            String fullJson = req.paramMap != null && !req.paramMap.isEmpty() ? (RestHandler.MIX_PARA_VALUE.equals(req.paramMap.get("_MIX_PARA_")) ? req.paramMap.get("arg0") : (!StringKit.isNull(jsonContent = ThreadLocalContextManager.getRequestInfo().getContent().getJsonContent()) ? jsonContent : JsonKit.object2JsonEx(req.paramMap))) : (!StringKit.isNull(jsonContent = ThreadLocalContextManager.getRequestInfo().getContent().getJsonContent()) ? jsonContent : null);
            if (fullJson != null) {
                ret[0] = JsonKit.json2ObjectEx(fullJson, parameterTypes[0]);
            } else {
                ret[0] = null;
                if (((Para)a).required()) {
                    throw new RuntimeException("Required param is not exists!" + req.operation);
                }
            }
            return true;
        }
        return false;
    }

    private Object getFromRequest(Map paraMap, ParaInfo paraInfo, Class<?> clz, int idx) {
        if (!paraMap.containsKey(paraInfo.name) && paraInfo.required) {
            throw new RuntimeException("Can't find http param:" + paraInfo.name);
        }
        String val = (String)paraMap.get(paraInfo.name);
        if (val == null && RestHandler.MIX_PARA_VALUE.equals(paraMap.get("_MIX_PARA_"))) {
            val = (String)paraMap.get("arg" + idx);
        }
        if (StringKit.isNull(val)) {
            Object o = nullDefaultMap.get(clz);
            return o;
        }
        return JsonKit.json2ObjectEx(val, clz);
    }

    private ParaInfo getParaInfo(Annotation[] anno, int index) {
        ParaInfo pi = new ParaInfo();
        String paramName = null;
        for (Annotation a : anno) {
            if (a.annotationType() != Para.class) continue;
            pi.name = paramName = ((Para)a).name().trim();
            pi.required = ((Para)a).required();
            break;
        }
        if (StringKit.isNull(paramName)) {
            pi.name = paramName = "arg" + index;
            pi.required = false;
        }
        return pi;
    }

    @Override
    public void call(CallParam cp) throws Throwable {
        int callType = cp.getCallType();
        if (callType == 0) {
            this.callStringParam(cp);
        } else if (callType == 1) {
            this.callRemteCall(cp);
        } else if (callType == 2) {
            this.callJson(cp);
        } else {
            throw new RuntimeException("known call type");
        }
    }

    private void callJson(CallParam cp) throws Throwable {
        JsonCallHelper.convertToHttp(cp);
        this.callStringParam(cp);
    }

    private void callStringParam(CallParam cp) throws Throwable {
        Object o = this.helper.getObject();
        if (o instanceof IDynamicService) {
            this.callStringParamForDynamic(cp);
        } else {
            this.callStringParamForConcreate(cp);
        }
    }

    private void callStringParamForDynamic(CallParam cp) throws Throwable {
        ObjectCallHelper.ObjectAndMethod oam = this.helper.get("execute", dynamicParamTypes);
        try {
            RestMethodState.reset();
            Object result = null;
            result = this.invokeWithServiceFilter4Dynamic(oam, cp.getPath(), cp.getOperation());
            RestMethodState.State state = RestMethodState.get();
            JsonResult jr = JsonResult.create();
            jr.setCode(state.code);
            jr.setMsg(state.message);
            jr.setSuccess(state.success);
            HashMap<String, Object> hm = new HashMap<String, Object>();
            if (restCompatibleReturn.booleanValue()) {
                hm.put("return", result);
            }
            hm.put("result", result);
            jr.setContent(hm);
            cp.setResult(jr.toJson(this.getJsonFormat(cp)));
        }
        catch (MethodIllegleAccessException e) {
            this.disposeException(cp, e);
        }
        catch (Exception e) {
            this.disposeException(cp, e);
        }
    }

    private void callStringParamForConcreate(CallParam cp) throws Throwable {
        Annotation[][] paraAnootation;
        ObjectCallHelper.ObjectAndMethod oam = this.helper.get(cp.getOperation(), null);
        if ("bizLogic".equals(this.helper.getObjeceDefine().getObjType())) {
            Class<?> intf = RuleServiceFactory.getRuleInterface(this.helper.getObjeceDefine().getBlName());
            paraAnootation = ReflactKit.findSingeMethodExactly(intf, oam.method.getName()).getParameterAnnotations();
        } else {
            paraAnootation = oam.method.getParameterAnnotations();
        }
        Object[] paraValue = this.getParaValueFromRequest(cp, paraAnootation, oam.method.getParameterTypes());
        try {
            RestMethodState.reset();
            Object result = null;
            result = this.invokeWithServiceFilter(cp.getPath(), oam, paraValue);
            RestMethodState.State state = RestMethodState.get();
            JsonResult jr = JsonResult.create();
            jr.setCode(state.code);
            jr.setMsg(state.message);
            jr.setSuccess(state.success);
            HashMap<String, Object> hm = new HashMap<String, Object>();
            if (restCompatibleReturn.booleanValue()) {
                hm.put("return", result);
            }
            hm.put("result", result);
            jr.setContent(hm);
            cp.setResult(jr.toJson(this.getJsonFormat(cp)));
        }
        catch (InvocationTargetException e) {
            Throwable targetEx = e.getTargetException();
            this.disposeException(cp, targetEx);
        }
        catch (MethodIllegleAccessException e) {
            this.disposeException(cp, e);
        }
        catch (Exception e) {
            this.disposeException(cp, e);
        }
    }

    private Tuple2<Integer, String> getJsonFormat(CallParam cp) {
        String o = cp.getParamMap().get("$sef");
        int format = o != null ? Integer.parseInt(o) : this.service_export_format;
        String cb = cp.getParamMap().get("callback");
        return Tuple2.with(format, cb);
    }

    private void disposeException(CallParam cp, Throwable e) {
        RemoteExceptionKits.RemoteExceptionInfo exInfo = RemoteExceptionKits.getExceptionInfo(e);
        JsonResult jr = JsonResult.create();
        jr.setSuccess(false);
        jr.setMsg(exInfo.getMsg());
        jr.setCode(exInfo.getCode());
        cp.setResult(jr.toJson(this.getJsonFormat(cp)));
        if (!(e instanceof RemoteExecuteException) || ((RemoteExecuteException)e).isNeedLog()) {
            ServiceFactory.getService(ILogService.class).getLogger(this.getClass().getName()).error((Object)e.getMessage(), e);
        }
    }

    public static void initCompatibleReturn() {
        String cfg = ConfigFactory.getStringConfig("platform.rest-compatible-return");
        if (cfg != null) {
            cfg = cfg.trim();
        }
        restCompatibleReturn = "true".equalsIgnoreCase(cfg) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        PluginEnvirement.INSTANCE.getStartLogger().log("platform.rest-compatible-return = " + restCompatibleReturn);
    }

    private Object invokeWithServiceFilter(String servicePath, final ObjectCallHelper.ObjectAndMethod oam, final Object[] paraValue) throws Throwable {
        InvocationContext ctx = new InvocationContext(servicePath, oam.object, oam.method, paraValue);
        return ServiceFilterManager.INSTANCE.executeWithFilter(ctx, new IMethodCallback(){

            @Override
            public Object run() throws Throwable {
                return ServiceInvoker.this.helper.invokeWithRuleSupport(oam, paraValue);
            }
        });
    }

    private Object invokeWithServiceFilter4Dynamic(final ObjectCallHelper.ObjectAndMethod oam, String servicePath, String dyncmicPath) throws Throwable {
        InvocationContext ctx = new InvocationContext(servicePath, oam.object, oam.method, dyncmicPath);
        final Object[] paraValue = new Object[]{ctx.getRequestInfo(), ctx.getDynamicPath()};
        return ServiceFilterManager.INSTANCE.executeWithFilter(ctx, new IMethodCallback(){

            @Override
            public Object run() throws Throwable {
                return ServiceInvoker.this.helper.invokeWithRuleSupport(oam, paraValue);
            }
        });
    }

    @Override
    public ObjectCallHelper getObjectCallHelper() {
        return this.helper;
    }

    private void callRemteCall(CallParam cp) throws Throwable {
        Class[] paraType = this.getParaTypes(cp);
        Object[] paraValue = this.getParaValues(cp);
        ObjectCallHelper.ObjectAndMethod oam = this.helper.get(cp.operation, paraType);
        try {
            Object result = this.invokeWithServiceFilter(cp.getPath(), oam, paraValue);
            cp.setResult(this.toResultString(result));
        }
        catch (InvocationTargetException ite) {
            Throwable targetEx = ite.getTargetException();
            RemoteExceptionKits.RemoteExceptionInfo exInfo = RemoteExceptionKits.getExceptionInfo(targetEx);
            String result = "$RE#" + JsonKit.object2Json(exInfo);
            cp.setResult(this.toResultString(result));
            this.log(targetEx);
        }
        catch (MethodIllegleAccessException e) {
            RemoteExceptionKits.RemoteExceptionInfo exInfo = RemoteExceptionKits.getExceptionInfo(e);
            String result = "$RE#" + JsonKit.object2Json(exInfo);
            cp.setResult(this.toResultString(result));
            this.log(e);
        }
        catch (Exception e) {
            RemoteExceptionKits.RemoteExceptionInfo exInfo = RemoteExceptionKits.getExceptionInfo(e);
            String result = "$RE#" + JsonKit.object2Json(exInfo);
            cp.setResult(this.toResultString(result));
            this.log(e);
        }
    }

    private Object[] getParaValues(CallParam cp) {
        String s = cp.getParamMap().get("PARA");
        if (StringKit.isNull(s)) {
            throw new RuntimeException("para value is null.");
        }
        return (Object[])SerializKit.deserialFromString(s);
    }

    private Class[] getParaTypes(CallParam cp) {
        String s = cp.getParamMap().get("TYPES");
        if (StringKit.isNull(s)) {
            throw new RuntimeException("para type is null.");
        }
        return (Class[])SerializKit.deserialFromString(s);
    }

    private String toResultString(Object result) {
        return SerializKit.encodeToString(result);
    }

    private void log(Throwable targetException) {
        ServiceFactory.getService(ILogService.class).getLogger(this.getClass().getName()).error(targetException);
    }

    static {
        nullDefaultMap.put(Integer.TYPE, new Integer(0));
        nullDefaultMap.put(Double.TYPE, new Double(0.0));
        nullDefaultMap.put(Float.TYPE, new Float(0.0f));
        nullDefaultMap.put(Long.TYPE, new Long(0L));
        dynamicParamTypes = new Class[]{RequesterInfo.class, String.class};
    }

    static class ParaInfo {
        String name;
        boolean required;

        ParaInfo() {
        }
    }
}

