/*
 * Decompiled with CFR 0.152.
 */
package net.jplugin.ext.webasic.impl.helper;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import net.jplugin.common.kits.ReflactKit;
import net.jplugin.common.kits.StringKit;
import net.jplugin.core.ctx.api.RuleProxyHelper;
import net.jplugin.core.ctx.api.RuleServiceFactory;
import net.jplugin.core.kernel.api.PluginEnvirement;
import net.jplugin.ext.webasic.api.ObjectDefine;

public class ObjectCallHelper {
    Object svcObject = null;
    Map<String, Method> methodMap = new Hashtable<String, Method>();
    ObjectDefine objeceDefine;

    public Object getObject() {
        this.initObject();
        return this.svcObject;
    }

    public ObjectCallHelper(ObjectDefine d) {
        this.objeceDefine = d;
        this.initObject();
    }

    public ObjectDefine getObjeceDefine() {
        return this.objeceDefine;
    }

    public ObjectAndMethod get(String requestMethodName, Class[] arg) {
        this.initObject();
        ObjectAndMethod ret = new ObjectAndMethod();
        ret.object = this.svcObject;
        ret.method = this.getMethod(requestMethodName, arg);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initObject() {
        if (this.svcObject == null) {
            ObjectCallHelper objectCallHelper = this;
            synchronized (objectCallHelper) {
                if (this.svcObject == null) {
                    this.svcObject = ObjectCallHelper.createObject(this.objeceDefine);
                }
            }
        }
    }

    private static Object createObject(ObjectDefine od) {
        String objType = od.getObjType();
        Class objClass = od.getObjClass();
        String blName = od.getBlName();
        if ("javaObject".equals(objType)) {
            if (objClass == null) {
                throw new RuntimeException("the service object class is null");
            }
            try {
                Object o = objClass.newInstance();
                PluginEnvirement.INSTANCE.resolveRefAnnotation(o);
                return o;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ("bizLogic".equals(objType)) {
            if (StringKit.isNull(blName)) {
                throw new RuntimeException("the bizlogic name is null");
            }
            Object obj = RuleServiceFactory.getRuleService(blName);
            if (obj == null) {
                throw new RuntimeException("can't find object:" + blName);
            }
            return obj;
        }
        throw new RuntimeException("Error obj type :" + objType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getMethod(String reqMethodName, Class[] arg) {
        String methodName = StringKit.isNull(reqMethodName) ? "index" : reqMethodName;
        if (StringKit.isNull(methodName)) {
            throw new RuntimeException("method name is null for req method name:" + reqMethodName);
        }
        String methodKey = this.getMethodKey(methodName, arg);
        Method method = this.methodMap.get(methodKey);
        if (method == null) {
            ObjectCallHelper objectCallHelper = this;
            synchronized (objectCallHelper) {
                method = this.methodMap.get(methodKey);
                if (method == null) {
                    if (this.svcObject == null) {
                        throw new RuntimeException("Object can't be null");
                    }
                    try {
                        method = arg != null ? this.svcObject.getClass().getMethod(methodName, arg) : ReflactKit.findSingeMethodExactly(this.svcObject.getClass(), methodName);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Can't find method [" + methodName + "] with arg:" + this.getString(arg) + " in " + this.svcObject.getClass().getName());
                    }
                    if (method == null || (1 & method.getModifiers()) == 0) {
                        throw new RuntimeException("Can't find method [" + methodName + "], the method not exists or Not a public method");
                    }
                    this.methodMap.put(methodKey, method);
                }
            }
        }
        return method;
    }

    private String getString(Class[] arg) {
        if (arg == null) {
            return "";
        }
        StringBuffer ret = new StringBuffer();
        for (Class c : arg) {
            ret.append(c.getName());
        }
        return ret.toString();
    }

    private String getMethodKey(String methodName, Class[] arg) {
        if (arg == null) {
            return methodName;
        }
        StringBuffer ret = new StringBuffer(methodName);
        for (Class c : arg) {
            ret.append("|").append(c.getName());
        }
        return ret.toString();
    }

    public Object invokeWithRuleSupport(ObjectAndMethod oam, Object[] paraValue) throws Throwable {
        if ("bizLogic".equals(this.getObjeceDefine().getObjType())) {
            return oam.method.invoke(oam.object, paraValue);
        }
        return RuleProxyHelper.invokeWithRule(oam.object, oam.method, paraValue);
    }

    public static class ObjectAndMethod {
        public Object object;
        public Method method;
    }
}

